/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fx.sky;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import java.util.HashSet;
import java.util.Set;

public class AtmosphericParameters {
    private Material skyMaterial;
    private Set<Material> groundMaterials = new HashSet<Material>();
    private Vector3f sunPosition = new Vector3f();
    private float lightIntensity;
    private float skyExposure;
    private float groundExposure;
    private float skyGamma;
    private float groundGamma;
    private Vector3f wavelengths = new Vector3f();
    private Vector3f wavelengthsPow4 = new Vector3f();
    private Vector3f invPow4Wavelengths = new Vector3f();
    private Vector3f invPow4WavelengthsKrESun = new Vector3f();
    private Vector4f scatteringConstants = new Vector4f();
    private Vector3f kWavelengths4PI = new Vector3f();
    private float mpaFactor;
    private float innerRadius;
    private float outerRadius;
    private float averageDensityScale;
    private float kFlatteningSky;
    private float skyDomeRadius;
    private float planetRadius;
    private float skyFlattening = 0.0f;
    private int nSamples = 2;
    private float fSamples = 2.0f;

    public AtmosphericParameters() {
        this.setWavelengths(0.65f, 0.57f, 0.475f);
        this.setRayleighConstant(0.0025f);
        this.setMieConstant(0.001f);
        this.mpaFactor = -0.99f;
        this.sunPosition.set(0.0f, 1.0f, 0.0f);
        this.lightIntensity = 20.0f;
        this.skyExposure = 1.0f;
        this.groundExposure = 1.0f;
        this.skyGamma = 2.0f;
        this.groundGamma = 0.0f;
        this.innerRadius = 10.0f;
        this.outerRadius = 10.25f;
        this.averageDensityScale = 0.25f;
        this.skyDomeRadius = 10.0f;
        this.planetRadius = 10.0f;
        this.kFlatteningSky = 0.0f;
    }

    public Material getSkyMaterial(AssetManager assets) {
        if (this.skyMaterial != null) {
            return this.skyMaterial;
        }
        this.skyMaterial = new Material(assets, "MatDefs/SkyAtmospherics.j3md");
        this.skyMaterial.setVector3("SunPosition", this.sunPosition);
        this.skyMaterial.setVector3("InvWavelengthsKrESun", this.invPow4WavelengthsKrESun);
        this.skyMaterial.setVector3("KWavelengths4PI", this.kWavelengths4PI);
        this.updateSkyMaterial(this.skyMaterial);
        return this.skyMaterial;
    }

    protected void updateMaterials() {
        if (this.skyMaterial != null) {
            this.updateSkyMaterial(this.skyMaterial);
        }
        for (Material m : this.groundMaterials) {
            this.applyGroundParameters(m);
        }
    }

    protected void updatePackedStructures() {
        float r4PI = this.scatteringConstants.y;
        float m4PI = this.scatteringConstants.w;
        this.kWavelengths4PI.x = this.invPow4Wavelengths.x * r4PI + m4PI;
        this.kWavelengths4PI.y = this.invPow4Wavelengths.y * r4PI + m4PI;
        this.kWavelengths4PI.z = this.invPow4Wavelengths.z * r4PI + m4PI;
        float rESun = this.scatteringConstants.x * this.lightIntensity;
        this.invPow4WavelengthsKrESun.x = this.invPow4Wavelengths.x * rESun;
        this.invPow4WavelengthsKrESun.y = this.invPow4Wavelengths.y * rESun;
        this.invPow4WavelengthsKrESun.z = this.invPow4Wavelengths.z * rESun;
    }

    protected void updateSkyMaterial(Material m) {
        this.updatePackedStructures();
        m.setFloat("KmESun", this.scatteringConstants.z * this.lightIntensity);
        m.setFloat("Exposure", this.skyExposure);
        m.setFloat("InnerRadius", this.innerRadius);
        m.setFloat("RadiusScale", 1.0f / (this.outerRadius - this.innerRadius));
        m.setFloat("Flattening", this.kFlatteningSky);
        m.setFloat("PlanetScale", this.outerRadius / this.skyDomeRadius);
        m.setFloat("AverageDensityScale", this.averageDensityScale);
        m.setFloat("InvAverageDensityHeight", 1.0f / ((this.outerRadius - this.innerRadius) * this.averageDensityScale));
        float g = this.mpaFactor;
        float g2 = g * g;
        float phasePrefix1 = 1.5f * ((1.0f - g2) / (2.0f + g2));
        float phasePrefix2 = 1.0f + g2;
        float phasePrefix3 = 2.0f * g;
        m.setFloat("PhasePrefix1", phasePrefix1);
        m.setFloat("PhasePrefix2", phasePrefix2);
        m.setFloat("PhasePrefix3", phasePrefix3);
        m.setFloat("Flattening", this.skyFlattening);
    }

    public void applyGroundParameters(Material m, boolean autoUpdate) {
        this.applyGroundParameters(m);
        if (autoUpdate) {
            this.groundMaterials.add(m);
        }
    }

    public void applyGroundParameters(Material m) {
        this.updatePackedStructures();
        m.setFloat("KmESun", this.scatteringConstants.z * this.lightIntensity);
        m.setVector3("SunPosition", this.sunPosition);
        m.setVector3("InvWavelengthsKrESun", this.invPow4WavelengthsKrESun);
        m.setVector3("KWavelengths4PI", this.kWavelengths4PI);
        m.setFloat("Exposure", this.groundExposure);
        m.setFloat("InnerRadius", this.innerRadius);
        m.setFloat("RadiusScale", 1.0f / (this.outerRadius - this.innerRadius));
        m.setFloat("PlanetScale", this.innerRadius / this.planetRadius);
        m.setFloat("AverageDensityScale", this.averageDensityScale);
        m.setFloat("InvAverageDensityHeight", 1.0f / ((this.outerRadius - this.innerRadius) * this.averageDensityScale));
    }

    public void setAverageDensityScale(float f) {
        if (this.averageDensityScale == f) {
            return;
        }
        this.averageDensityScale = f;
        this.updateMaterials();
    }

    public float getAverageDensityScale() {
        return this.averageDensityScale;
    }

    public void setSkyFlattening(float f) {
        this.skyFlattening = f;
        this.updateMaterials();
    }

    public float getSkyFlattening() {
        return this.skyFlattening;
    }

    public void setSkyDomeRadius(float f) {
        if (this.skyDomeRadius == f) {
            return;
        }
        this.skyDomeRadius = f;
        this.updateMaterials();
    }

    public float getSkyDomeRadius() {
        return this.skyDomeRadius;
    }

    public void setPlanetRadius(float f) {
        if (this.planetRadius == f) {
            return;
        }
        this.planetRadius = f;
        this.updateMaterials();
    }

    public float getPlanetRadius() {
        return this.planetRadius;
    }

    public final void setRayleighConstant(float f) {
        if (this.scatteringConstants.x == f) {
            return;
        }
        this.scatteringConstants.x = f;
        this.scatteringConstants.y = f * 4.0f * (float)Math.PI;
        this.updateMaterials();
    }

    public float getRayleighConstant() {
        return this.scatteringConstants.x;
    }

    public final void setMieConstant(float f) {
        if (this.scatteringConstants.z == f) {
            return;
        }
        this.scatteringConstants.z = f;
        this.scatteringConstants.w = f * 4.0f * (float)Math.PI;
        this.updateMaterials();
    }

    public float getMieConstant() {
        return this.scatteringConstants.z;
    }

    public final void setMiePhaseAsymmetryFactor(float f) {
        if (this.mpaFactor == f) {
            return;
        }
        this.mpaFactor = f;
        this.updateMaterials();
    }

    public float getMiePhaseAsymmetryFactor() {
        return this.mpaFactor;
    }

    public void setLightDirection(Vector3f dir) {
        this.sunPosition.set(-dir.x, -dir.y, -dir.z);
    }

    public Vector3f getLightDirection() {
        return this.sunPosition.negate();
    }

    public void setLightIntensity(float f) {
        if (this.lightIntensity == f) {
            return;
        }
        this.lightIntensity = f;
        this.updateMaterials();
    }

    public float getLightIntensity() {
        return this.lightIntensity;
    }

    public void setSkyExposure(float f) {
        if (this.skyExposure == f) {
            return;
        }
        this.skyExposure = f;
        this.updateMaterials();
    }

    public float getSkyExposure() {
        return this.skyExposure;
    }

    public void setGroundExposure(float f) {
        if (this.groundExposure == f) {
            return;
        }
        this.groundExposure = f;
        this.updateMaterials();
    }

    public float getGroundExposure() {
        return this.groundExposure;
    }

    public final void setWavelengths(float r, float g, float b) {
        this.wavelengths.set(r, g, b);
        this.wavelengthsPow4.x = FastMath.pow((float)this.wavelengths.x, (float)4.0f);
        this.wavelengthsPow4.y = FastMath.pow((float)this.wavelengths.y, (float)4.0f);
        this.wavelengthsPow4.z = FastMath.pow((float)this.wavelengths.z, (float)4.0f);
        this.invPow4Wavelengths.x = 1.0f / this.wavelengthsPow4.x;
        this.invPow4Wavelengths.y = 1.0f / this.wavelengthsPow4.y;
        this.invPow4Wavelengths.z = 1.0f / this.wavelengthsPow4.z;
        this.updateMaterials();
    }

    public void setRedWavelength(float f) {
        if (this.wavelengths.x == f) {
            return;
        }
        this.setWavelengths(f, this.wavelengths.y, this.wavelengths.z);
    }

    public float getRedWavelength() {
        return this.wavelengths.x;
    }

    public void setGreenWavelength(float f) {
        if (this.wavelengths.y == f) {
            return;
        }
        this.setWavelengths(this.wavelengths.x, f, this.wavelengths.z);
    }

    public float getGreenWavelength() {
        return this.wavelengths.y;
    }

    public void setBlueWavelength(float f) {
        if (this.wavelengths.z == f) {
            return;
        }
        this.setWavelengths(this.wavelengths.x, this.wavelengths.y, f);
    }

    public float getBlueWavelength() {
        return this.wavelengths.z;
    }

    public ColorRGBA calculateGroundColor(ColorRGBA color, Vector3f direction, float distance, float elevation, ColorRGBA target) {
        if (target == null) {
            target = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
        }
        float planetScale = this.innerRadius / this.planetRadius;
        Vector3f[] parms = this.calculateGroundInAtmosphere(direction, distance * planetScale, elevation * planetScale, null);
        target.r = (parms[0].x + color.r * parms[1].x) * this.groundExposure;
        target.g = (parms[0].y + color.g * parms[1].y) * this.groundExposure;
        target.b = (parms[0].z + color.b * parms[1].z) * this.groundExposure;
        target.a = color.a;
        return target;
    }

    private float scale(float fCos) {
        float x = 1.0f - fCos;
        return this.averageDensityScale * FastMath.exp((float)(-0.00287f + x * (0.459f + x * (3.83f + x * (-6.8f + x * 5.25f)))));
    }

    public Vector3f[] calculateGroundInAtmosphere(Vector3f direction, float distance, float elevation, Vector3f[] target) {
        if (target == null) {
            target = new Vector3f[]{new Vector3f(), new Vector3f()};
        }
        float scaleDepth = this.averageDensityScale;
        float scaleOverScaleDepth = 1.0f / ((this.outerRadius - this.innerRadius) * this.averageDensityScale);
        float radiusScale = 1.0f / (this.outerRadius - this.innerRadius);
        Vector3f invWavelengthsKrESun = this.invPow4WavelengthsKrESun;
        float mESun = this.scatteringConstants.z * this.lightIntensity;
        Vector3f camPos = new Vector3f(0.0f, this.innerRadius + elevation, 0.0f);
        float rayLength = distance;
        Vector3f start = camPos.add(direction.mult(distance));
        direction = direction.mult(-1.0f);
        float height = start.y;
        float offset = this.innerRadius - height;
        float depth = FastMath.exp((float)(scaleOverScaleDepth * offset));
        float startAngle = direction.dot(start) / height;
        float startOffset = depth * this.scale(startAngle);
        float sampleLength = rayLength / this.fSamples;
        float scaledLength = sampleLength * radiusScale;
        Vector3f sampleStep = direction.mult(sampleLength);
        Vector3f samplePoint = start.add(sampleStep.mult(0.5f));
        float scatter = 0.0f;
        Vector3f accumulator = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f attenuation = new Vector3f(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < this.nSamples; ++i) {
            height = samplePoint.y;
            offset = this.innerRadius - height;
            depth = FastMath.exp((float)(scaleOverScaleDepth * offset));
            float lightAngle = this.sunPosition.dot(samplePoint) / height;
            float cameraAngle = direction.dot(samplePoint) / height;
            scatter = startOffset + depth * (this.scale(lightAngle) - this.scale(cameraAngle));
            attenuation.x = FastMath.exp((float)(-scatter * this.kWavelengths4PI.x));
            attenuation.y = FastMath.exp((float)(-scatter * this.kWavelengths4PI.y));
            attenuation.z = FastMath.exp((float)(-scatter * this.kWavelengths4PI.z));
            accumulator.addLocal(attenuation.mult(depth * scaledLength));
            samplePoint.addLocal(sampleStep);
        }
        target[1].set(attenuation);
        target[0].x = accumulator.x * (invWavelengthsKrESun.x + mESun);
        target[0].y = accumulator.y * (invWavelengthsKrESun.y + mESun);
        target[0].z = accumulator.z * (invWavelengthsKrESun.z + mESun);
        return target;
    }
}

