/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile;

import com.google.common.base.MoreObjects;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.tile.TerrainImageId;
import com.simsilica.mworld.tile.TileImageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerrainImage
implements TileImageData<TerrainImage> {
    static Logger log = LoggerFactory.getLogger(TerrainImage.class);
    private TerrainImageId id;
    private DataVersion version;
    private byte generationLevel;
    private int size;
    private short[] elevations;
    private byte[] types;
    private byte[] lights;

    public TerrainImage(TerrainImageId id, DataVersion version) {
        this(id, version, 0);
    }

    public TerrainImage(TerrainImageId id, DataVersion version, int generationLevel) {
        this.id = id;
        this.version = version;
        this.generationLevel = (byte)generationLevel;
        this.size = id.getResolution().getSamples();
        this.elevations = new short[this.size * this.size];
        this.types = new byte[this.size * this.size];
        this.lights = new byte[this.size * this.size];
    }

    public TerrainImageId getId() {
        return this.id;
    }

    public DataVersion getVersion() {
        return this.version;
    }

    public void setGenerationLevel(int generationLevel) {
        if (this.generationLevel > generationLevel) {
            throw new IllegalArgumentException("Generation level cannot go backwards.");
        }
        this.generationLevel = (byte)generationLevel;
    }

    public int getGenerationLevel() {
        return this.generationLevel;
    }

    public int getSize() {
        return this.size;
    }

    private int index(int x, int y) {
        return this.size * y + x;
    }

    public final void setElevation(int x, int y, short elevation) {
        this.elevations[this.index((int)x, (int)y)] = elevation;
    }

    public final short getElevation(int x, int y) {
        return this.elevations[this.index(x, y)];
    }

    public final void setType(int x, int y, byte type) {
        this.types[this.index((int)x, (int)y)] = type;
    }

    public final byte getType(int x, int y) {
        return this.types[this.index(x, y)];
    }

    public final void setLight(int x, int y, byte light) {
        this.lights[this.index((int)x, (int)y)] = light;
    }

    public final boolean updateLight(int x, int y, byte light) {
        int index = this.index(x, y);
        byte existing = this.lights[index];
        if (existing == light) {
            return false;
        }
        if (existing >= 0 && light > existing) {
            this.lights[index] = light;
            return true;
        }
        if (existing <= 0 && light < 0) {
            if (existing == 0) {
                this.lights[index] = light;
            } else {
                int val = (light < existing ? light : existing) - 1;
                this.lights[index] = (byte)(val < -15 ? -15 : val);
            }
            return true;
        }
        return false;
    }

    public final byte getLight(int x, int y) {
        return this.lights[this.index(x, y)];
    }

    public final short[] getElevations() {
        return this.elevations;
    }

    public final byte[] getTypes() {
        return this.types;
    }

    public final byte[] getLights() {
        return this.lights;
    }

    @Override
    public void setData(TerrainImage from, int xStart, int yStart, int xSize, int ySize) {
        log.info("setData(" + from + ", " + xStart + ", " + yStart + ", " + xSize + ", " + ySize + ")");
        if (from.size != this.size) {
            throw new IllegalArgumentException("Size mismatch:" + this.size + " versus:" + from.size);
        }
        xStart = xStart * this.size / 1024;
        yStart = yStart * this.size / 1024;
        xSize = xSize * this.size / 1024;
        ySize = ySize * this.size / 1024;
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                int index = this.index(xStart + i, yStart + j);
                this.elevations[index] = from.elevations[index];
                this.types[index] = from.types[index];
                this.lights[index] = from.lights[index];
            }
        }
    }

    public void write(TerrainImage image) {
        if (image.size < this.size) {
            throw new IllegalArgumentException("Cannot extrapolate image data from a lower resolution:" + (Object)((Object)image.getId().getResolution()));
        }
        int skip = image.size / this.size;
        int src = 0;
        int target = 0;
        short[] srcElevations = image.elevations;
        byte[] srcTypes = image.types;
        byte[] srcLights = image.lights;
        for (int i = 0; i < this.size; ++i) {
            src = i * skip * image.size;
            for (int j = 0; j < this.size; ++j) {
                this.elevations[target] = srcElevations[src];
                this.types[target] = srcTypes[src];
                this.lights[target] = srcLights[src];
                ++target;
                src += skip;
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("id", (Object)this.getId()).add("version", (Object)this.getVersion()).add("size", this.size).toString();
    }
}

