/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fractal;

import com.simsilica.fractal.ElevationSource;

public class ElevationSources {
    public static ElevationSource clamp(ElevationSource source, double min, double max) {
        return new Clamp(source, min, max);
    }

    public static ElevationSource offset(ElevationSource source, double delta) {
        return new Offset(source, delta);
    }

    public static ElevationSource max(ElevationSource source1, ElevationSource source2) {
        return new MaxElevation(source1, source2);
    }

    public static ElevationSource maxThreshold(ElevationSource source, double threshold, double replace) {
        return new MaxThreshold(source, threshold, replace);
    }

    private static class Clamp
    implements ElevationSource {
        ElevationSource delegate;
        double min;
        double max;

        public Clamp(ElevationSource delegate, double min, double max) {
            if (delegate == null) {
                throw new IllegalArgumentException("Delegate cannot be null");
            }
            this.delegate = delegate;
            this.min = min;
            this.max = max;
        }

        @Override
        public double getElevation(double x, double y) {
            double val = this.delegate.getElevation(x, y);
            if (val < this.min) {
                val = this.min;
            } else if (val > this.max) {
                val = this.max;
            }
            return val;
        }
    }

    private static class Offset
    implements ElevationSource {
        ElevationSource delegate;
        double delta;

        public Offset(ElevationSource delegate, double delta) {
            if (delegate == null) {
                throw new IllegalArgumentException("Delegate cannot be null");
            }
            this.delegate = delegate;
            this.delta = delta;
        }

        @Override
        public double getElevation(double x, double y) {
            double val = this.delegate.getElevation(x, y);
            return val + this.delta;
        }
    }

    private static class MaxThreshold
    implements ElevationSource {
        ElevationSource delegate;
        double threshold;
        double replace;

        public MaxThreshold(ElevationSource delegate, double threshold, double replace) {
            if (delegate == null) {
                throw new IllegalArgumentException("Delegate cannot be null");
            }
            this.delegate = delegate;
            this.threshold = threshold;
            this.replace = replace;
        }

        @Override
        public double getElevation(double x, double y) {
            double val = this.delegate.getElevation(x, y);
            if (val < this.threshold) {
                val = this.replace;
            }
            return val;
        }
    }

    private static class MaxElevation
    implements ElevationSource {
        ElevationSource source1;
        ElevationSource source2;

        public MaxElevation(ElevationSource source1, ElevationSource source2) {
            if (source1 == null || source2 == null) {
                throw new IllegalArgumentException("Delegate sources cannot be null");
            }
            this.source1 = source1;
            this.source2 = source2;
        }

        @Override
        public double getElevation(double x, double y) {
            return Math.max(this.source1.getElevation(x, y), this.source2.getElevation(x, y));
        }
    }
}

