/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.sim;

import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecurringTaskSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(RecurringTaskSystem.class);
    private List<Function<SimTime, Boolean>> tasks = new ArrayList<Function<SimTime, Boolean>>();
    private volatile Function[] taskArray;
    private static Function[] EMPTY_ARRAY = new Function[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecurringTask(Function<SimTime, Boolean> task) {
        List<Function<SimTime, Boolean>> list = this.tasks;
        synchronized (list) {
            this.tasks.add(task);
            this.taskArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecurringTask(Function<SimTime, Boolean> task) {
        List<Function<SimTime, Boolean>> list = this.tasks;
        synchronized (list) {
            this.tasks.remove(task);
            this.taskArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Function[] getArray() {
        Function[] result = this.taskArray;
        if (result != null) {
            return result;
        }
        List<Function<SimTime, Boolean>> list = this.tasks;
        synchronized (list) {
            if (this.taskArray != null) {
                return this.taskArray;
            }
            this.taskArray = this.tasks.toArray(EMPTY_ARRAY);
            return this.taskArray;
        }
    }

    @Override
    public void update(SimTime time) {
        for (Function f : this.getArray()) {
            Object result = f.apply(time);
            if (Objects.equals(result, Boolean.TRUE)) continue;
            this.removeRecurringTask(f);
        }
    }

    @Override
    protected void initialize() {
    }

    @Override
    protected void terminate() {
    }
}

