/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.sim.common;

import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.common.Decay;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecaySystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(DecaySystem.class);
    private EntityData ed;
    private DecayContainer entities;

    @Override
    protected void initialize() {
        this.ed = this.getSystem(EntityData.class, true);
        this.entities = new DecayContainer(this.ed);
    }

    @Override
    protected void terminate() {
    }

    @Override
    public void start() {
        super.start();
        this.entities.start();
    }

    protected void destroyEntity(Entity e) {
        if (log.isTraceEnabled()) {
            log.trace("Removing:" + e);
        }
        this.ed.removeEntity(e.getId());
    }

    @Override
    public void update(SimTime time) {
        super.update(time);
        this.entities.update();
        long current = time.getTime();
        for (Entity e : this.entities.getArray()) {
            Decay d = (Decay)e.get(Decay.class);
            if (!d.isDead(current)) continue;
            this.destroyEntity(e);
        }
    }

    @Override
    public void stop() {
        this.entities.stop();
        super.stop();
    }

    private class DecayContainer
    extends EntityContainer<Entity> {
        public DecayContainer(EntityData ed) {
            super(ed, Decay.class);
        }

        public Entity[] getArray() {
            return (Entity[])super.getArray();
        }

        @Override
        protected Entity addObject(Entity e) {
            return e;
        }

        @Override
        protected void updateObject(Entity object, Entity e) {
        }

        @Override
        protected void removeObject(Entity object, Entity e) {
        }
    }
}

