/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.bounding.BoundingBox;
import com.jme3.material.MatParamOverride;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.shader.VarType;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Name;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.ConstantCellData;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.io.BlocksFileFormat;
import mythruna.client.ui.ContainerViewState;
import mythruna.client.ui.ItemType;
import mythruna.es.ContainerVolume;
import mythruna.es.ObjectName;
import mythruna.es.ObjectVolume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemView
extends Node {
    static Logger log = LoggerFactory.getLogger(ItemView.class);
    private int cellSize = 5;
    private ContainerViewState parent;
    private Entity entity;
    private ItemType type;
    private Node model;
    private Vector3f overlayPosition = new Vector3f();
    private float overlayScale = 1.0f;

    public ItemView(ContainerViewState parent, Entity entity) {
        this.parent = parent;
        this.entity = entity;
        EntityData ed = parent.getEntityData();
        EntityId id = entity.getId();
        ShapeInfo shape = (ShapeInfo)ed.getComponent(id, ShapeInfo.class);
        String modelName = shape.getShapeName(ed);
        ObjectVolume outerVolume = (ObjectVolume)ed.getComponent(id, ObjectVolume.class);
        ContainerVolume innerVolume = (ContainerVolume)ed.getComponent(id, ContainerVolume.class);
        Object objectName = modelName + ":" + id;
        ObjectName on = (ObjectName)ed.getComponent(id, ObjectName.class);
        if (on != null) {
            objectName = on.getName(ed);
        } else {
            Name name = (Name)ed.getComponent(id, Name.class);
            if (name != null) {
                objectName = name.getName();
            }
        }
        CellArray cells = null;
        if (innerVolume != null) {
            String altName = modelName.replace(".blocks", "-notop.blocks");
            try {
                cells = BlocksFileFormat.loadCellArray((String)altName);
                log.info("loaded:" + cells + " for:" + altName);
            }
            catch (Exception e) {
                log.warn("Error loading:" + altName + " falling back to real version");
            }
        }
        if (cells == null) {
            try {
                cells = BlocksFileFormat.loadCellArray((String)modelName);
                log.info("loaded:" + cells + " for:" + modelName);
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading:" + modelName, e);
            }
        }
        Quatd itemRotation = new Quatd();
        Vec3d itemOffset = new Vec3d();
        double itemScale = 1.0;
        int xSlots = 1;
        int ySlots = 1;
        double areaScale = 1.0;
        log.info("modelName:" + modelName);
        log.info("outerVolume:" + outerVolume);
        log.info("innerVolume:" + innerVolume);
        Vec3d size = outerVolume.getSize().mult(100.0);
        log.info("scaled size:" + size);
        double totalVolume = size.x * size.y * size.z;
        if (innerVolume != null) {
            itemRotation.fromAngles(1.5707963705062866, 0.0, 0.0);
            itemOffset.z -= outerVolume.getSize().y;
            double area = size.x * size.z;
            areaScale = Math.sqrt(totalVolume / area);
            log.info("----- container areaScale:" + areaScale + "  depth:" + totalVolume / area);
            itemScale = shape.getScale() * areaScale * 100.0;
            double width = outerVolume.getSize().x * areaScale * 100.0;
            double height = outerVolume.getSize().z * areaScale * 100.0;
            log.info("width:" + width / 100.0 + " height:" + height / 100.0 + "  cellSize:" + this.cellSize);
            xSlots = Math.max(1, (int)Math.floor(width / (double)this.cellSize));
            ySlots = Math.max(1, (int)Math.floor(height / (double)this.cellSize));
            log.info("container slots:" + xSlots + ", " + ySlots);
        } else {
            double area;
            double width = 0.0;
            double height = 0.0;
            int[] axes = parent.sortAxes(size);
            log.info("size:" + size + "  axes:" + axes[0] + ", " + axes[1] + ", " + axes[2]);
            if (axes[0] == 1) {
                if (axes[1] == 0) {
                    area = size.x * size.y;
                    width = size.x;
                    height = size.y;
                } else {
                    log.info("y,z rotate 90 around y");
                    itemRotation.fromAngles(0.0, 1.5707963705062866, 0.0);
                    area = size.z * size.y;
                    width = size.z;
                    height = size.y;
                    itemOffset.z += outerVolume.getSize().x;
                }
                itemOffset.y -= outerVolume.getSize().y;
            } else if (axes[0] == 2) {
                log.info("z rotate 90 around x");
                itemRotation.fromAngles(-1.5707963705062866, 3.1415927410125732, 0.0);
                if (axes[1] == 0) {
                    area = size.x * size.z;
                    width = size.x;
                    height = size.z;
                } else {
                    log.info("z,y rotate 90 around y");
                    itemRotation = new Quatd().fromAngles(0.0, 1.5707963705062866, 0.0).mult(itemRotation);
                    area = size.z * size.y;
                    width = size.y;
                    height = size.z;
                }
            } else {
                log.info("x rotate 90 around z");
                if (axes[1] == 1) {
                    area = size.x * size.y;
                    width = size.y;
                    height = size.x;
                } else {
                    log.info("x,z rotate 90 around y");
                    itemRotation = new Quatd().fromAngles(0.0, 1.5707963705062866, 0.0).mult(itemRotation);
                    area = size.x * size.z;
                    width = size.z;
                    height = size.x;
                }
            }
            double adjustedArea = area * (double)Math.round(shape.getScale() * 100.0);
            areaScale = Math.sqrt(totalVolume / adjustedArea);
            log.info("totalVolume:" + totalVolume + "  area:" + area + "  adjustedArea:" + adjustedArea + "  areaScale:" + areaScale);
            itemScale = shape.getScale() * areaScale * 100.0;
            xSlots = Math.max(1, (int)Math.round((width *= areaScale) / (double)this.cellSize));
            ySlots = Math.max(1, (int)Math.round((height *= areaScale) / (double)this.cellSize));
            log.info("width:" + width + "  height:" + height + "  itemScale:" + itemScale + "  xSlots:" + xSlots + "  ySlots:" + ySlots);
            double adjustedWidth = xSlots * this.cellSize;
            double adjustedHeight = ySlots * this.cellSize;
            double xScale = adjustedWidth / width;
            double yScale = adjustedHeight / height;
            double slotScale = Math.min(xScale, yScale);
            itemScale *= slotScale;
            itemScale *= (double)0.9f;
        }
        this.type = new ItemType(xSlots, ySlots, itemScale, itemRotation, itemOffset);
        Node parts = new Node("Parts:" + id);
        parent.getGeomFactory().generateBlocks(parts, cells, (CellData)new ConstantCellData(LightUtils.DIRECT_SUN), true);
        log.info("shape scale:" + shape.getScale());
        parts.addMatParamOverride(new MatParamOverride(VarType.Float, "CarveScale", (Object)Float.valueOf((float)(1.0 / shape.getScale()))));
        parts.setLocalScale((float)itemScale);
        parts.setLocalRotation(itemRotation.toQuaternion());
        double w = xSlots * this.cellSize;
        double h = ySlots * this.cellSize;
        BoundingBox bbox = (BoundingBox)parts.getWorldBound();
        Vector3f center = bbox.getCenter();
        double xOffset = w * 0.5 - (double)center.x;
        double yOffset = h * 0.5 - (double)center.y;
        double zOffset = 0.0;
        zOffset = innerVolume != null ? (double)(-bbox.getMax(null).z) : (double)(-bbox.getMin(null).z);
        parts.move((float)xOffset, (float)yOffset, (float)zOffset);
        parts.move(0.0f, (float)(-h), 0.0f);
        this.overlayPosition.x = (float)(w * 0.5);
        this.overlayPosition.y = (float)(-h * 0.5);
        this.overlayPosition.z = bbox.getZExtent() * 2.0f;
        float scaleBase = Math.min(2, Math.min(xSlots, ySlots));
        this.overlayScale = scaleBase != 0.0f ? scaleBase : 0.1f;
        Node node = new Node("Object:" + id);
        node.attachChild((Spatial)parts);
        node.setUserData("oid", (Object)id.getId());
        this.model = node;
        this.model.setUserData("objectName", objectName);
        this.attachChild((Spatial)this.model);
    }

    public Spatial getModel() {
        return this.model;
    }

    public ItemType getItemType() {
        return this.type;
    }

    public Vector2f getItemSize() {
        return new Vector2f((float)(this.type.getXSlots() * this.cellSize), (float)(this.type.getYSlots() * this.cellSize));
    }

    public void addOverlay(Spatial overlay) {
        float scale = this.overlayScale * (float)this.cellSize / 32.0f;
        overlay.setLocalTranslation(this.overlayPosition);
        overlay.setLocalScale(scale);
        overlay.move(-16.0f * scale, 16.0f * scale, 0.0f);
        this.model.attachChild(overlay);
    }

    public void removeOverlay(Spatial overlay) {
        this.model.detachChild(overlay);
    }

    public void runAction(String actionName, Object ... parms) {
        this.parent.getGameSession().runAction(this.entity.getId(), actionName, parms);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "@" + System.identityHashCode((Object)this) + "[entity:" + this.entity + "]";
    }
}

