/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.io;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.ColumnStates;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnStatesProtocol {
    static Logger log = LoggerFactory.getLogger(ColumnStatesProtocol.class);
    private int version = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ColumnStates state, OutputStream rawOut) throws IOException {
        try (BitOutputStream out = new BitOutputStream(rawOut);){
            this.write(state, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnStates read(InputStream rawIn) throws IOException {
        try (BitInputStream in = new BitInputStream(rawIn);){
            ColumnStates columnStates = this.read(in);
            return columnStates;
        }
    }

    public void write(ColumnStates state, BitOutputStream out) throws IOException {
        out.writeBits(this.version, 16);
        out.writeLongBits(state.getTileId().getId(), 64);
        TreeSet<Short> ids = new TreeSet<Short>(state.getTileLocalColumnIds());
        out.writeBits(ids.size(), 10);
        for (Short s : ids) {
            out.writeBits((int)s.shortValue(), 10);
        }
    }

    public ColumnStates read(BitInputStream in) throws IOException {
        int version = in.readBits(16);
        TileId tileId = new TileId(in.readLongBits(64));
        ColumnStates result = new ColumnStates(tileId);
        int count = in.readBits(10);
        for (int i = 0; i < count; ++i) {
            short s = (short)in.readBits(10);
            result.getTileLocalColumnIds().add(s);
        }
        return result;
    }
}

