/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.cave;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.FluidUtils;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.morph.AbstractMorphology;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import mythruna.world.cave.Influencer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointInfluencer
extends AbstractMorphology
implements Influencer,
Serializable {
    static Logger log = LoggerFactory.getLogger(PointInfluencer.class);
    private static final long serialVersionUID = 42L;
    private Vec3i point;
    private int innerRadius;
    private int outerRadius;
    private byte type;
    private short fluidLevel;
    private byte fluidType;
    public static boolean tileCalcOn = true;
    public static boolean columnCalcOn = true;
    public static int curveType = 5;
    public static double roughnessThreshold = 0.1;

    public PointInfluencer(Vec3i point, int innerRadius, int outerRadius) {
        this(point, innerRadius, outerRadius, 0, 0, 0);
    }

    public PointInfluencer(Vec3i point, int innerRadius, int outerRadius, int type, int fluidLevel, int fluidType) {
        this.point = point;
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
        this.type = (byte)type;
        this.fluidLevel = (short)fluidLevel;
        this.fluidType = (byte)fluidType;
    }

    public Vec3i getPoint() {
        return this.point;
    }

    public int getInnerRadius() {
        return this.innerRadius;
    }

    public int getOuterRadius() {
        return this.outerRadius;
    }

    @Override
    public Vec3d getCenter() {
        return this.point.toVec3d();
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public int getFluidLevel() {
        return this.fluidLevel;
    }

    public byte getFluidType() {
        return this.fluidType;
    }

    @Override
    public Vec3i getMin() {
        return this.point.subtract(this.outerRadius, 0, this.outerRadius);
    }

    @Override
    public Vec3i getMax() {
        return this.point.add(this.outerRadius, 0, this.outerRadius);
    }

    public Iterable<Short> getAffectedColumns(TileId tileId) {
        ArrayList<Short> results = new ArrayList<Short>();
        Vec3i origin = tileId.getWorld(null);
        int xMin = this.point.x - this.outerRadius - origin.x;
        int zMin = this.point.z - this.outerRadius - origin.z;
        int xMax = this.point.x + this.outerRadius - origin.x;
        int zMax = this.point.z + this.outerRadius - origin.z;
        if (xMax < 0 || zMax < 0) {
            return results;
        }
        if (xMin >= 1024 || zMin >= 1024) {
            return results;
        }
        xMin = Math.max(0, xMin);
        xMax = Math.min(xMax, 1023);
        zMin = Math.max(0, zMin);
        zMax = Math.min(zMax, 1023);
        Vec3i min = ColumnId.GRID.worldToCell((double)xMin, 0.0, (double)zMin);
        Vec3i max = ColumnId.GRID.worldToCell((double)xMax, 0.0, (double)zMax);
        for (int x = min.x; x <= max.x; ++x) {
            for (int z = min.z; z <= max.z; ++z) {
                short id = ColumnId.toTileLocalIndexId((int)x, (int)z);
                results.add(id);
            }
        }
        return results;
    }

    private double clamp(double v, double min, double max) {
        if (v <= min) {
            return min;
        }
        if (v >= max) {
            return max;
        }
        return v;
    }

    private int mix(int v1, int v2, double mix) {
        double d = (double)v1 * (1.0 - mix) + (double)v2 * mix;
        return (int)Math.round(d);
    }

    private double smoothStep(double edge0, double edge1, double x) {
        double t = this.clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
        return t * t * (3.0 - 2.0 * t);
    }

    private double smoothStep(double x) {
        double t = this.clamp(x, 0.0, 1.0);
        return t * t * (3.0 - 2.0 * t);
    }

    @Override
    public boolean intersects(TileId tileId) {
        Vec3i tileOrigin = tileId.getWorld(null);
        Vec3i min = this.point.subtract(this.outerRadius, 0, this.outerRadius);
        Vec3i max = this.point.add(this.outerRadius, 0, this.outerRadius);
        if (max.x < tileOrigin.x || max.z < tileOrigin.z) {
            return false;
        }
        return min.x < tileOrigin.x + 1024 && min.z < tileOrigin.z + 1024;
    }

    public boolean morph(Tile tile, Random rand) {
        if (!tileCalcOn) {
            return false;
        }
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        int size = terrain.getSize();
        int spread = 1024 / size;
        TileId tileId = tile.getTileId();
        Vec3i origin = tileId.getWorld(null);
        int xMin = this.point.x - this.outerRadius - origin.x;
        int zMin = this.point.z - this.outerRadius - origin.z;
        int xMax = this.point.x + this.outerRadius - origin.x;
        int zMax = this.point.z + this.outerRadius - origin.z;
        xMin = Math.max(xMin, 0);
        zMin = Math.max(zMin, 0);
        xMax = Math.min(xMax, 1023);
        zMax = Math.min(zMax, 1023);
        xMin /= spread;
        zMin /= spread;
        xMax /= spread;
        zMax /= spread;
        double outerRadiusSq = this.outerRadius * this.outerRadius;
        double innerRadiusSq = this.innerRadius * this.innerRadius;
        double effectRadiusSq = outerRadiusSq;
        Vec3d localPoint = this.point.subtract(origin).toVec3d();
        boolean changed = false;
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                double xRel = (double)(x * spread) - localPoint.x;
                double zRel = (double)(z * spread) - localPoint.z;
                double dSq = xRel * xRel + zRel * zRel;
                if (dSq > effectRadiusSq) continue;
                double yExtent = 0.0;
                if (effectRadiusSq > dSq) {
                    yExtent = Math.sqrt(effectRadiusSq - dSq);
                }
                int yMin = (int)this.clamp(Math.floor((double)this.point.y - yExtent) + 1.0, 1.0, 640.0);
                int yMax = (int)this.clamp(Math.floor((double)this.point.y + yExtent) + 1.0, 1.0, 640.0);
                short elevation = terrain.getElevation(x, z);
                if (elevation > yMax || elevation < yMin) continue;
                terrain.setElevation(x, z, (short)yMin);
                fluid.setType(x, z, (byte)-1);
                changed = true;
            }
        }
        return changed;
    }

    public boolean morph(ColumnData colData, Tile tile, Random rand) {
        if (!columnCalcOn) {
            return false;
        }
        Vec3i origin = colData.getColumnId().getWorld(null);
        Vec3i localOrigin = origin.subtract(tile.getTileId().getWorld(null));
        Vec3d localPoint = this.point.subtract(origin).toVec3d();
        double outerRadiusSq = this.outerRadius * this.outerRadius;
        double innerRadiusSq = this.innerRadius * this.innerRadius;
        LeafData[] leafs = colData.getLeafs();
        FluidData[] fluid = colData.getFluid();
        int topFluid = FluidUtils.setLevel((int)this.fluidType, (int)6);
        int fullFluid = FluidUtils.setLevel((int)this.fluidType, (int)8);
        boolean changed = false;
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                double xRel = (double)x - localPoint.x;
                double zRel = (double)z - localPoint.z;
                double dSq = xRel * xRel + zRel * zRel;
                if (!(dSq <= outerRadiusSq)) continue;
                double yExtent = 0.0;
                if (outerRadiusSq > dSq) {
                    yExtent = Math.sqrt(outerRadiusSq - dSq);
                }
                int yMin = (int)this.clamp(Math.floor((double)this.point.y - yExtent) + 1.0, 1.0, 640.0);
                int yMax = (int)this.clamp(Math.floor((double)this.point.y + yExtent) + 1.0, 1.0, 640.0);
                int lowest = -1;
                int highest = -1;
                for (int y = yMin; y <= yMax; ++y) {
                    double yRel = (double)y - localPoint.y;
                    boolean skip = false;
                    dSq = xRel * xRel + yRel * yRel + zRel * zRel;
                    if (dSq > outerRadiusSq) continue;
                    if (dSq >= innerRadiusSq) {
                        double dice;
                        double chance = (dSq - innerRadiusSq) / (outerRadiusSq - innerRadiusSq);
                        switch (curveType) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                chance *= chance;
                                break;
                            }
                            case 2: {
                                chance *= chance * chance;
                                break;
                            }
                            case 3: {
                                chance = this.smoothStep(chance);
                                break;
                            }
                            case 4: {
                                chance = 1.0 - chance;
                                chance *= chance;
                                chance = 1.0 - chance;
                                break;
                            }
                            case 5: {
                                chance = 1.0 - chance;
                                chance *= chance * chance * chance;
                                chance = 1.0 - chance;
                            }
                        }
                        if (chance <= roughnessThreshold || (dice = rand.nextDouble()) < chance) continue;
                    }
                    int layer = y / 32;
                    LeafData leaf = leafs[layer];
                    int j = y % 32;
                    leaf.setCell(x, j, z, 0);
                    if (y < this.fluidLevel) {
                        if (y == this.fluidLevel - 1) {
                            fluid[layer].setCell(x, j, z, topFluid);
                        } else {
                            fluid[layer].setCell(x, j, z, fullFluid);
                        }
                    }
                    changed = true;
                }
            }
        }
        return changed;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[point:" + this.point + ", innerRadius:" + this.innerRadius + ", outerRadius:" + this.outerRadius + "]";
    }
}

