/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.crig;

import com.simsilica.crig.RigType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RigProtocol {
    static Logger log = LoggerFactory.getLogger(RigProtocol.class);
    private static long version = 42L;

    public static void saveRigType(RigType rigType, File file) throws IOException {
        FileOutputStream fOut = new FileOutputStream(file);
        GZIPOutputStream gzip = new GZIPOutputStream(fOut);
        try (ObjectOutputStream out = new ObjectOutputStream(gzip);){
            out.writeLong(version);
            out.writeObject(rigType);
        }
    }

    public static RigType loadRigType(File file) throws IOException {
        FileInputStream fIn = new FileInputStream(file);
        return RigProtocol.loadRigType(fIn);
    }

    public static RigType loadRigType(String resource) throws IOException {
        InputStream in = RigProtocol.class.getResourceAsStream(resource);
        if (in == null) {
            throw new IOException("Resource not found:" + resource);
        }
        return RigProtocol.loadRigType(in);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RigType loadRigType(InputStream rawIn) throws IOException {
        GZIPInputStream gzip = new GZIPInputStream(rawIn);
        try (ObjectInputStream in = new ObjectInputStream(gzip);){
            long version = in.readLong();
            RigType rigType = (RigType)in.readObject();
            return rigType;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Missing class reading rig binary", e);
        }
    }
}

