/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net.character;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.ShapeInfo;
import java.util.Objects;
import mythruna.es.ClothingInfo;
import mythruna.es.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clothing {
    static Logger log = LoggerFactory.getLogger(Clothing.class);
    private final String designName;
    private final String name;
    private final String itemName;
    private final String shapeName;

    public Clothing(String designName, String name, String itemName, String shapeName) {
        this.designName = designName;
        this.name = name;
        this.itemName = itemName;
        this.shapeName = shapeName;
    }

    public String getName() {
        return this.name;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getShapeName() {
        return this.shapeName;
    }

    public static Clothing create(EntityData ed, EntityId entity) {
        ObjectName objectName = (ObjectName)ed.getComponent(entity, ObjectName.class);
        String on = objectName.getName(ed);
        if (Objects.equals("!private!", on)) {
            log.info("   skipping !private! clothing design");
            return null;
        }
        ClothingInfo info = (ClothingInfo)ed.getComponent(entity, ClothingInfo.class);
        String name = objectName.getName(ed);
        ShapeInfo shapeInfo = (ShapeInfo)ed.getComponent(entity, ShapeInfo.class);
        String shapeName = shapeInfo.getShapeName(ed);
        return new Clothing(info.getName(), name, on, shapeName);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Clothing other = (Clothing)o;
        if (!Objects.equals(this.designName, other.designName)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.itemName, other.itemName)) {
            return false;
        }
        return Objects.equals(this.shapeName, other.shapeName);
    }

    public int hashCode() {
        return Objects.hash(this.designName, this.name, this.itemName, this.shapeName);
    }

    public String fullToString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("designName", (Object)this.designName).add("name", (Object)this.name).add("itemName", (Object)this.itemName).add("shapeName", (Object)this.shapeName).toString();
    }

    public String toString() {
        return this.designName;
    }
}

