/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.opengl;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import mythruna.client.opengl.Resolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModeInfo {
    static Logger log = LoggerFactory.getLogger(ModeInfo.class);
    private Resolution resolution;
    private int frequency;
    private int bitsPerPixel;
    private boolean fullscreen;

    private ModeInfo() {
    }

    public ModeInfo(Resolution resolution, int frequency, int bitsPerPixel, boolean fullscreen) {
        this.resolution = resolution;
        this.frequency = frequency;
        this.bitsPerPixel = bitsPerPixel;
        this.fullscreen = fullscreen;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public int hashCode() {
        return Objects.hash(this.resolution, this.frequency, this.bitsPerPixel, this.fullscreen);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ModeInfo other = (ModeInfo)o;
        if (!Objects.equals(other.resolution, this.resolution)) {
            return false;
        }
        if (other.frequency != this.frequency) {
            return false;
        }
        if (other.bitsPerPixel != this.bitsPerPixel) {
            return false;
        }
        return other.fullscreen == this.fullscreen;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("resolution", (Object)this.resolution).add("frequency", this.frequency).add("bitsPerPixel", this.bitsPerPixel).add("fullscreen", this.fullscreen).toString();
    }
}

