/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.crig.es;

import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerConfig {
    static Logger log = LoggerFactory.getLogger(LayerConfig.class);
    private String layer;
    private String[] actions;

    protected LayerConfig() {
    }

    public LayerConfig(String layer, String ... actions) {
        this.layer = layer;
        this.actions = actions;
    }

    public String getLayer() {
        return this.layer;
    }

    public String[] getActions() {
        return this.actions;
    }

    public int indexOf(String action) {
        int i = 0;
        for (String s : this.actions) {
            if (Objects.equals(s, action)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public double getPart(String action) {
        double size = this.actions.length;
        if (size <= 1.0) {
            return 0.0;
        }
        int i = 0;
        for (String s : this.actions) {
            if (Objects.equals(s, action)) {
                return (double)i / size;
            }
            ++i;
        }
        return -1.0;
    }

    public String getAction(double part) {
        if (part < 0.0) {
            return null;
        }
        int i = (int)((part + 0.1) * (double)this.actions.length);
        return this.actions[i];
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[layer:" + this.layer + ", actions:" + Arrays.asList(this.actions) + "]";
    }
}

