/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLocator;
import com.jme3.asset.AssetManager;
import com.jme3.asset.plugins.UrlAssetInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UrlLocator
implements AssetLocator {
    private static final Logger logger = Logger.getLogger(UrlLocator.class.getName());
    private URL root;

    @Override
    public void setRootPath(String rootPath) {
        try {
            this.root = new URL(rootPath);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid rootUrl specified", ex);
        }
    }

    @Override
    public AssetInfo locate(AssetManager manager, AssetKey key) {
        String name = key.getName();
        try {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            URL url = new URL(this.root.toExternalForm() + name);
            return UrlAssetInfo.create(manager, key, url);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Error while locating " + name, ex);
            return null;
        }
    }
}

