/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.phys.KinematicInfo;
import com.simsilica.mblock.phys.MBlockContact;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.Contact;
import com.simsilica.mphys.ContactListener;
import com.simsilica.mphys.FilteredContactListener;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mphys.RigidBody;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import mythruna.sim.DestructibleObjectSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(ContactSystem.class);
    private EntityData ed;
    private MPhysSystem<MBlockShape> physics;
    private PhysicsSpace<EntityId, MBlockShape> space;
    private ContactObserver observer = new ContactObserver();
    private FilteredContactListener<EntityId, MBlockShape> filter;
    private SimTime simTime;
    private DestructibleObjectSystem destructibleSystem;
    private boolean[] ignore;

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class, true);
        this.physics = (MPhysSystem)this.getSystem(MPhysSystem.class, true);
        this.space = this.physics.getPhysicsSpace();
        this.destructibleSystem = (DestructibleObjectSystem)((Object)this.getSystem(DestructibleObjectSystem.class, true));
        if (this.space.getContactDispatcher() != null) {
            this.filter = new FilteredContactListener((ContactListener)this.observer, this.space.getContactDispatcher());
            this.space.setContactDispatcher(this.filter);
        } else {
            this.space.setContactDispatcher((ContactListener)this.observer);
        }
    }

    public void start() {
        BlockType[] types = BlockTypeIndex.getTypes();
        this.ignore = new boolean[types.length];
        for (int i = 0; i < types.length; ++i) {
            BlockType type = types[i];
            if (type == null) continue;
            BlockName name = type.getName();
            String base = name.getBase();
            if ("magic-white".equals(base)) {
                this.ignore[i] = true;
                continue;
            }
            if ("magic-red".equals(base)) {
                this.ignore[i] = true;
                continue;
            }
            if ("magic-green".equals(base)) {
                this.ignore[i] = true;
                continue;
            }
            if ("magic-blue".equals(base)) {
                this.ignore[i] = true;
                continue;
            }
            if ("fire".equals(base)) {
                this.ignore[i] = true;
                continue;
            }
            if (!"flora".equals(base)) continue;
            this.ignore[i] = true;
        }
    }

    public void update(SimTime time) {
        this.simTime = time;
    }

    protected void terminate() {
        if (this.filter != null) {
            this.space.setContactDispatcher(this.filter.getDelegate());
        } else {
            this.space.setContactDispatcher(null);
        }
    }

    private static Vec3d parentToChild(Vec3d loc, Vec3d childLoc, Quatd childOrient) {
        Vec3d relative = loc.subtract(childLoc);
        childOrient.inverse().mult(relative, relative);
        return relative;
    }

    private static Vec3d childToParent(Vec3d loc, Vec3d childLoc, Quatd childOrient) {
        Vec3d result = childOrient.mult(loc);
        result.addLocal(childLoc);
        return result;
    }

    protected void calculateKinematics(MBlockContact<EntityId> mc) {
        KinematicInfo k2;
        KinematicInfo k1 = mc.part1 != null ? mc.part1.getKinematicInfo() : null;
        KinematicInfo kinematicInfo = k2 = mc.part2 != null ? mc.part2.getKinematicInfo() : null;
        if (k1 != null) {
            if (k1.getScale() == 0.0) {
                return;
            }
            RigidBody body1 = mc.body1;
            Vec3d bodyCp = body1.worldToLocal(mc.contactPoint, null);
            Vec3d shapeCp = ((MBlockShape)body1.shape).bodyToShape(bodyCp, null);
            Vec3d kNowRelative = ContactSystem.parentToChild(shapeCp, k1.getCurrentLocation(), k1.getCurrentOrientation());
            Vec3d kPrevShape = ContactSystem.childToParent(kNowRelative, k1.getLastLocation(), k1.getLastOrientation());
            Vec3d prevBodyCp = ((MBlockShape)body1.shape).shapeToBody(kPrevShape, null);
            Vec3d prevCp = body1.localToWorld(prevBodyCp, null);
            Vec3d kVel = prevCp.subtract(mc.contactPoint);
            EntityId target = mc.body2 != null ? (EntityId)mc.body2.id : null;
            this.destructibleSystem.chop((EntityId)body1.id, target, mc.contactPoint, mc.contactNormal, kVel);
        }
    }

    private class ContactObserver
    implements ContactListener<EntityId, MBlockShape> {
        private ContactObserver() {
        }

        public void newContact(Contact<EntityId, MBlockShape> contact) {
            if (log.isTraceEnabled()) {
                log.trace("newContact(" + contact + ")");
            }
            MBlockContact mc = (MBlockContact)contact;
            ContactSystem.this.calculateKinematics((MBlockContact<EntityId>)mc);
            if (mc.body1 != null && mc.body1.getInverseMass() > 1.0) {
                return;
            }
            if (mc.type1 > 0 && ContactSystem.this.ignore[mc.type1]) {
                mc.disable();
                return;
            }
            if (mc.type2 > 0 && ContactSystem.this.ignore[mc.type2]) {
                mc.disable();
                return;
            }
        }
    }
}

