/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tile;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.SedectileId;
import com.simsilica.mworld.db.ObjectDb;
import mythruna.world.tile.Feature;
import mythruna.world.tile.FeatureRegistry;
import mythruna.world.tile.Sedectile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Workspace {
    static Logger log = LoggerFactory.getLogger(Workspace.class);
    private static final int[][] OUT_FLAGS = new int[5][5];
    private static final int[][] IN_FLAGS = new int[5][5];
    private FeatureRegistry features;
    private ObjectDb<SedectileId, Sedectile> sedectileDb;
    private Sedectile center;
    private int radius;
    private int size;
    private Sedectile[] sedectiles;

    public Workspace(Sedectile center, int radius, FeatureRegistry features, ObjectDb<SedectileId, Sedectile> sedectileDb) {
        this.features = features;
        this.sedectileDb = sedectileDb;
        this.center = center;
        this.radius = radius;
        this.size = radius * 2 + 1;
        this.sedectiles = new Sedectile[this.size * this.size];
        this.sedectiles[this.index((int)0, (int)0)] = center;
        Vec3i centerLoc = center.getSedectileId().getWorld(null);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                Sedectile neighbor;
                if (x == 0 && z == 0) continue;
                Vec3i local = centerLoc.add(x * 16384, 0, z * 16384);
                SedectileId nId = SedectileId.fromWorld((Vec3i)local);
                this.sedectiles[this.index((int)x, (int)z)] = neighbor = (Sedectile)sedectileDb.get((Object)nId);
            }
        }
    }

    public int getRadius() {
        return this.radius;
    }

    public int getSize() {
        return this.size;
    }

    private int index(int x, int z) {
        return (z + this.radius) * this.size + (x + this.radius);
    }

    public Sedectile getSedectile(int x, int z) {
        return this.sedectiles[this.index(x, z)];
    }

    public Vec3i getOrigin(Vec3i target) {
        return this.center.getSedectileId().getWorld(target);
    }

    public <T extends Feature> boolean addFeature(Feature<T> feature) {
        int count = 0;
        for (Sedectile sedectile : this.sedectiles) {
            if (!sedectile.addFeature(feature)) continue;
            ++count;
        }
        this.features.updateFeature(feature);
        return count > 0;
    }

    public void close() {
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                Sedectile sedectile = this.getSedectile(x - this.radius, z - this.radius);
                sedectile.setInFlags(IN_FLAGS[x][z]);
                sedectile.setOutFlags(OUT_FLAGS[x][z]);
            }
        }
        for (Sedectile sedectile : this.sedectiles) {
            if (sedectile == null) continue;
            this.sedectileDb.update((Object)sedectile.getSedectileId(), (Object)sedectile);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[center:" + this.center.getSedectileId() + "]";
    }

    static {
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 5; ++z) {
                int inFlags = 0;
                int outFlags = 0;
                boolean isBorder = !(x != 0 && x != 4 || z != 0 && z != 4);
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        int nz;
                        int nx;
                        if (i == 0 && j == 0 || (nx = x + i) < 0 || nx >= 5 || (nz = z + j) < 0 || nz >= 5) continue;
                        boolean isNeighborSeedArea = nx > 0 && nx < 4 && nz > 0 && nz < 4;
                        int dirMask = Sedectile.getDirMask(i, j);
                        if (isNeighborSeedArea) {
                            inFlags |= dirMask;
                        }
                        if (isBorder) continue;
                        outFlags |= dirMask;
                    }
                }
                Workspace.OUT_FLAGS[x][z] = outFlags;
                Workspace.IN_FLAGS[x][z] = inFlags;
            }
        }
    }
}

