
//#import "MatDefs/LightTools.glsllib"
//#import "MatDefs/wind.glsllib"
//#import "MatDefs/ByteUtils.glsllib"
#import "Common/ShaderLib/BlinnPhongLighting.glsllib"
//#import "Common/ShaderLib/Lighting.glsllib"

#ifdef USE_FOG
#import "Common/ShaderLib/MaterialFog.glsllib"
//varying float fog_distance;
uniform vec4 m_FogColor;

#ifdef FOG_LINEAR
uniform vec2 m_LinearFog;
#endif

#ifdef FOG_EXP
uniform float m_ExpFog;
#endif

#ifdef FOG_EXPSQ
uniform float m_ExpSqFog;
#endif

#endif // end fog

#ifdef HAS_FADE_DISTANCE
uniform float m_FadeDistance;
#endif

uniform vec4 m_Ambient;
uniform vec4 m_Diffuse;
uniform vec4 m_TimeParms;

uniform sampler2D m_NoiseMap;

uniform float m_LocalLightStrength;

attribute vec3 inPosition;
attribute vec4 inColor;
attribute vec4 inTexCoord;

varying vec4 color;
varying vec4 texCoord;

uniform mat4 g_WorldViewProjectionMatrix;
uniform float g_Time;
uniform mat4 g_WorldViewMatrix;
uniform mat4 g_WorldMatrix;
uniform mat4 g_ViewMatrix;
uniform mat3 g_NormalMatrix;
uniform vec3 g_CameraPosition;
//uniform float m_Quadratic;
uniform vec4 g_LightColor;
uniform vec4 g_LightPosition;
uniform vec4 g_AmbientLightColor;
uniform mat4 g_ProjectionMatrix;
uniform vec2 g_Resolution;

const float SIZE_MULTIPLIER = 1.0;
attribute float inSize;

uniform float m_Alpha;

void lightComputeDir(in vec4 position, out vec4 lightDir){
    vec3 tempVec = position.xyz * -1.0;
    lightDir = vec4(normalize(tempVec), 1.0);
}


void main(){
    vec4 pos = vec4(inPosition, 1.0);

    gl_Position = g_WorldViewProjectionMatrix * pos;
    color = inColor;

    texCoord = inTexCoord; // * INV_TEX;
    
    // Calculate the view position and view dir
    vec3 wvPosition = (g_WorldViewMatrix * pos).xyz;
    vec3 viewDir = normalize(-wvPosition);
    vec4 wvLightPos = (g_ViewMatrix * vec4(g_LightPosition.xyz, g_LightColor.w));
    wvLightPos.w = g_LightPosition.w;
    vec4 lightColor = g_LightColor;
    
    vec3 localLightDir = normalize((g_ViewMatrix * vec4(g_CameraPosition, 1.0)).xyz - wvPosition);    
    
    // Color actually contains the amount of natural light and the
    // amount of local light.
    //float sunLight = inColor.a;
    vec4 modelLight = inColor;
    vec3 localLightColor = inColor.rgb;

    // Calculate the sun-based coloring
    #ifdef USE_AMBIENT
        vec3 AmbientSum  = (m_Ambient  * g_AmbientLightColor * modelLight.a).rgb;
    #else
        // Defaults: Ambient and diffuse are white, specular is sunlight.
        vec3 AmbientSum  = g_AmbientLightColor.rgb * modelLight.a;
    #endif
    
    #ifdef USE_DIFFUSE
        vec4 DiffuseSum  =  m_Diffuse  * vec4(lightColor.rgb * modelLight.a, 1.0);
    #else
        vec4 DiffuseSum  =  vec4(lightColor.rgb * modelLight.a, 1.0);
    #endif
    
    #ifdef USE_SPECULAR
        vec3 SpecularSum = (m_Specular * lightColor).rgb * modelLight.a;
    #else
        vec3 SpecularSum = vec3(modelLight.a); 
    #endif
 
 
        
    vec4 lightDir;
    lightComputeDir(wvLightPos, lightDir);
 
    vec4 worldPos = g_WorldMatrix * pos;        
    vec3 objCamDir = g_CameraPosition.xyz - worldPos.xyz;
    #ifdef USE_FOG
        float fog_distance = length(objCamDir);
    #endif
    vec3 normal = normalize(objCamDir);
    
    // Make sure the flowers always point a little bit up 
    //normal.y = clamp( 0.72, 1.0, normal.y ); // + m_TimeParms.x;
 
    // This really only applies to things like flowers because normally
    // the grasss they sit in is always-up and it looks strange to have the
    // flowers go completely black from the back.   
    //normal.y = clamp(0.8, 1.0, normal.y);
    normal.y = 2.0;
    
    vec3 wvNormal  = normalize(g_NormalMatrix * normal);

    //float test = dot(wvNormal, lightDir.xyz);
    ////diffuse = vec4(test);
    ////diffuse.xyz = vec3(abs(lightDir.y)); //abs(lightDir.xyz);
    ////diffuse.xyz = wvNormal;
    //diffuse.xyz = vec3(test);
    //diffuse.a = 1.0;
    
    //color = applyLighting( diffuse, sunFactor, localLightColor,
    //                       wvNormal, lightDir.xyz, viewDir,
    //                       AmbientSum, DiffuseSum,
    //                       m_Diffuse, m_Ambient, m_TimeParms.x );
    //color.a = 1.0;
    
    float spotFallOff = 1.0;
    float shininess = 0.0; //m_Shininess;
    
    vec2   sunlight = computeLighting(wvNormal, viewDir, lightDir.xyz, lightDir.w * spotFallOff, shininess) ;
    vec2   localLight = computeLighting(wvNormal, viewDir, localLightDir, 1.0, shininess) ;

    // Note: to support more advanced things like emissive, we really need
    // to do the lighting calculations in the frag shader once we've looked up
    // texture colors.
    // We'll get the flat stuff working for now.

    color.a = 1.0;
    
    // Sunlight contribution
    color.rgb = AmbientSum       +
                + DiffuseSum.rgb * vec3(sunlight.x)
                + SpecularSum.rgb * vec3(sunlight.y) * modelLight.a;
    

    // We want to dull the local light contribution in direct daylight.
    float sunContrib = min(1.0, length(DiffuseSum.rgb) * modelLight.a * sunlight.x + length(AmbientSum.rgb) * modelLight.a);
    float localContrib = max(0.0, min(1.0, 1.25 - sunContrib));
 
    // Local light contribution
    color.rgb += modelLight.xyz * 0.25 * 1.0 * localContrib 
                   + modelLight.xyz * 1.0 * vec3(localLight.x) * localContrib 
                   + modelLight.xyz * 1.0 * vec3(localLight.y) * localContrib;
    
    #ifdef HAS_EMISSIVE
        color.rgb += emissiveColor.rgb * emissiveColor.a * localContrib;
    #endif    
    
    //diffuse.xyz = viewDir;
    //diffuse.xy = localLight;
    //diffuse.z = 0.0;  
    
/*    
vec2 computeLighting(in vec3 norm, in vec3 viewDir, in vec3 lightDir, in float attenuation, in float shininess){
   float diffuseFactor = lightComputeDiffuse(norm, lightDir);
   float specularFactor = lightComputeSpecular(norm, viewDir, lightDir, shininess);      
   if (shininess <= 1.0) {
       specularFactor = 0.0; // should be one instruction on most cards ..
   }
   specularFactor *= diffuseFactor;
   return vec2(diffuseFactor, specularFactor) * vec2(attenuation);
}*/    
    
    /*

       // Workaround, since it is not possible to modify varying variables
       vec4 SpecularSum2 = vec4(SpecularSum, 1.0);
       #ifdef USE_REFLECTION
            vec4 refColor = Optics_GetEnvColor(m_EnvMap, refVec.xyz);

            // Interpolate light specularity toward reflection color
            // Multiply result by specular map
            //specularColor = mix(SpecularSum2 * sunlight.y, refColor, refVec.w) * specularColor;
            // Kilroy to see if this is ever used
            specularColor = vec4(1.0, 0.0, 0.0, 1.0);

            SpecularSum2 = vec4(1.0);
            sunlight.y = 1.0;
       #endif

        vec4 ambientColor = diffuseColor;
         
        #ifdef MATERIAL_COLORS
            ambientColor *= m_Ambient;
            diffuseColor *= m_Diffuse;
            specularColor *= m_Specular;  
        #endif
        
       // Sunlight contribution
       gl_FragColor.rgb =  AmbientSum       * ambientColor.rgb  +
                           DiffuseSum.rgb   * diffuseColor.rgb  * vec3(sunlight.x) +
                           SpecularSum2.rgb * specularColor.rgb * vec3(sunlight.y) * modelLight.a;
 
        #ifdef GLASS_SPECULAR
            alpha = max(0.0, alpha) + max(sunlight.y, localLight.y);
        #endif 
 
       // We want to dull the local light contribution in direct daylight.
       float sunContrib = min(1.0, length(DiffuseSum.rgb) * modelLight.a * sunlight.x + length(AmbientSum.rgb) * modelLight.a);
       //float localContrib = length(modelLight.xyz) * localLight.x;
       //float localContrib = min(1.25 - (sunlight.x * modelLight.a), length(modelLight.xyz));
       float localContrib = max(0.0, min(1.0, 1.25 - sunContrib));
 
       // Local light contribution                          
       gl_FragColor.rgb += modelLight.xyz * 0.25 * diffuseColor.rgb * localContrib 
                           + modelLight.xyz * diffuseColor.rgb * vec3(localLight.x) * localContrib 
                           + modelLight.xyz * specularColor.rgb * vec3(localLight.y) * localContrib;
       //gl_FragColor.rgb += modelLight.xyz * 0.25 * diffuseColor.rgb
       //                      + modelLight.xyz * diffuseColor.rgb * vec3(localLight.x)
       //                      + 1.0 * specularColor.rgb * vec3(localLight.y);       
    
        #ifdef HAS_EMISSIVE
            vec4 emissiveColor;
            #ifdef HAS_EMISSIVE_MAP
                emissiveColor = texture2D(m_EmissiveMap, newTexCoord); 
            #else
                emissiveColor = diffuseColor;
            #endif
            emissiveColor *= m_Emissive;
            gl_FragColor.rgb += emissiveColor.rgb * emissiveColor.a * localContrib;
        #endif
    
///////////////////////////////////////////
*/    
    
    
    
    
    
    
    
    //color = diffuse; 
    
 
    // Calculate the local space scale   
    float scale = length(g_WorldMatrix[0].xyz);
               
    //vec3 wind = tipWind( pos.xyz, floor(pos.y) + 0.1, vec3(1.0, 0.0, 0.0), 0.5, g_Time, m_NoiseMap );              
    //gl_Position.xyz += wind * scale;
      
    // Calculate the point size 
    float d = distance(g_CameraPosition.xyz, worldPos.xyz);

// From the point cloud stuff in mworld. 
//        Camera cam = getApplication().getCamera();
//        float c = cam.getProjectionMatrix().m00;
//        c *= cam.getWidth() * 0.5f;
//        // send attenuation params
//        mat.setFloat("Quadratic", c);  
//    float size = scale * (SIZE_MULTIPLIER * m_Quadratic) / d;
//    if( length(offset.xz) > CLIP_DISTANCE ) {
//        size = 0.0;
//    }
//    //gl_PointSize = max(1.0, size);
//    gl_PointSize = size;

    //float quadratic = 642.66; 
    float quadratic = g_ProjectionMatrix[0][0] * g_Resolution.x * 0.5;
 
    float size = inSize * scale * (SIZE_MULTIPLIER * quadratic) / d;
    //float size = scale * (SIZE_MULTIPLIER * 642.66) / d;
 
    //gl_PointSize = max(1.0, ((inSize * SIZE_MULTIPLIER * m_Quadratic) / d) * scale );
    //gl_PointSize = 5.0 * scale;
    gl_PointSize = size;

/* Something for later....
jmonkeyengine:  Kirill: float C = cam.getProjectionMatrix().m00;
C *= cam.getWidth() * 0.5f;
this.getMaterial().setFloat("Quadratic", C);
Kirill: this is how its done for particles
*/



    // We use the fog flag because we know it's turned off when
    // we are in tools and stuff. 
//    #ifdef USE_FOG       
//        // Fade with distance
//        color.a *= 1.0 - (max(d, 1.0) * 1.0 / 64.0);
//    #endif


    #ifdef USE_FOG
        // add fog after the lighting because shadows will cause the fog to darken
        // which just results in the geometry looking like it's changed color
        float atmosphere = modelLight.a;    
        //atmosphere = 1.0 - atmosphere;
        //atmosphere *= atmosphere;
        //atmosphere = 1.0 - atmosphere;
        atmosphere = clamp(atmosphere * 2.0, 0.0, 1.0);
        vec4 fogColor = m_FogColor * atmosphere;
         
        #ifdef FOG_LINEAR
            color = getFogLinear(color, fogColor, m_LinearFog.x, m_LinearFog.y, fog_distance);
        #endif
        #ifdef FOG_EXP
            color = getFogExp(color, fogColor, m_ExpFog, fog_distance);
        #endif
        #ifdef FOG_EXPSQ
            color = getFogExpSquare(color, fogColor, m_ExpSqFog, fog_distance);
        #endif

        #ifdef HAS_FADE_DISTANCE
            // We use the fog distance for clip so we require fog for clipping to work
            float clip = min(1.0, fog_distance/m_FadeDistance);            
            clip *= clip;
            clip = 1.0 - clip;
            
            // Shift the curve a bit so that near objects never have fractional distance-based alpha
            // For example, if the clip is 100 and the object is 25 units away then
            // the initial clip is 0.25... which we'll square: 0.0625 and subtract from
            // 1: 0.9375 
            // * 1.2 = 1.125... clamped to 1.
            // In our above example, for a multiplier of 1.2, the switch over point is 0.9129
            // so for 9 meters everything is as solid as it wants to be.
            // 1.5 gives us more: 0.816
            clip = min(1.0, 1.5 * clip);
                        
            color.a *= clip;
        #endif
    #endif // end fog
    
    

 
}


