/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortTermMemory<T> {
    static Logger log = LoggerFactory.getLogger(ShortTermMemory.class);
    private double expireInterval;
    private Map<T, Memory> memories = new HashMap<T, Memory>();
    private double expireTimeout;

    public ShortTermMemory(double expireInterval) {
        this.expireInterval = expireInterval;
        this.expireTimeout = Math.random() * expireInterval;
    }

    public boolean add(T value, double expires) {
        Memory mem = this.memories.get(value);
        if (mem != null) {
            mem.update(expires);
            return false;
        }
        log.info("new memory:" + value);
        mem = new Memory(this, value, expires);
        this.memories.put(value, mem);
        return true;
    }

    public boolean updateIfExists(T value, double expires) {
        Memory mem = this.memories.get(value);
        if (mem == null) {
            return false;
        }
        log.info("refresh memory:" + value);
        mem.update(expires);
        return true;
    }

    public boolean contains(Object value) {
        return this.memories.containsKey(value);
    }

    public void update(double time, double step) {
        this.expireTimeout -= step;
        if (this.expireTimeout > 0.0) {
            return;
        }
        this.expireTimeout = this.expireInterval;
        if (this.memories.isEmpty()) {
            return;
        }
        Iterator<Memory> it = this.memories.values().iterator();
        while (it.hasNext()) {
            Memory mem = it.next();
            if (!(mem.expires < time)) continue;
            it.remove();
            log.info("expired memory:" + mem.value);
        }
    }

    private class Memory {
        private double expires;
        private T value;

        public Memory(ShortTermMemory shortTermMemory, T value, double expires) {
            this.value = value;
            this.expires = expires;
        }

        public void update(double expires) {
            this.expires = expires;
        }
    }
}

