/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.Material;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import mythruna.GameConstants;
import mythruna.client.GameSessionState;
import mythruna.client.view.AvatarState;
import mythruna.es.debug.DebugShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugShapeViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(DebugShapeViewState.class);
    private EntityData ed;
    private VersionedReference<Vec3d> posRef;
    private Grid grid = GameConstants.PHYSICS_GRID;
    private Node root;
    private Vec3i centerCell = new Vec3i(0, -10000, 0);
    private Vec3i centerWorld;
    private ShapeContainer shapes;
    private Vec3i shapeCenter = new Vec3i();
    private int shapeGridRadius = 2;
    private ComponentFilter[][] gridFilters;

    public DebugShapeViewState() {
        this.setEnabled(false);
    }

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    protected void initialize(Application app) {
        this.ed = ((GameSessionState)this.getState(GameSessionState.class)).getEntityData();
        this.root = new Node("areaRoot");
        this.shapes = new ShapeContainer(this.ed);
        this.resetModelFilter();
        this.posRef = ((AvatarState)this.getState(AvatarState.class)).createPositionReference();
        this.updateViewPosition((Vec3d)this.posRef.get(), true);
        this.shapes.start();
    }

    protected void cleanup(Application app) {
        this.shapes.stop();
    }

    protected void onEnable() {
        this.getRoot().attachChild((Spatial)this.root);
    }

    public void update(float tpf) {
        if (this.posRef.update()) {
            this.updateViewPosition((Vec3d)this.posRef.get(), false);
        }
        this.shapes.update();
    }

    protected void onDisable() {
        this.root.removeFromParent();
    }

    protected void updateViewPosition(Vec3d center, boolean forceUpdate) {
        Vec3i newCenter = this.grid.worldToCell(center);
        if (!forceUpdate && newCenter.equals((Object)this.centerCell)) {
            return;
        }
        this.centerCell.set(newCenter);
        this.centerWorld = this.grid.cellToWorld(this.centerCell);
        log.info("centerWorld:" + this.centerWorld);
        this.resetRelativeCoordinates();
        if (this.shapeCenter.x != this.centerCell.x || this.shapeCenter.z != this.centerCell.z) {
            this.shapeCenter.x = this.centerCell.x;
            this.shapeCenter.z = this.centerCell.z;
            this.resetModelFilter();
        }
    }

    protected void resetRelativeCoordinates() {
        for (ShapeView view : this.shapes.getArray()) {
            view.updateRelativePosition();
        }
    }

    protected void resetModelFilter() {
        int size = this.shapeGridRadius * 2 + 1;
        this.gridFilters = new ComponentFilter[size][size];
        ComponentFilter[] filters = new ComponentFilter[size * size];
        int xOffset = this.shapeCenter.x - this.shapeGridRadius;
        int zOffset = this.shapeCenter.z - this.shapeGridRadius;
        int index = 0;
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                ComponentFilter filter;
                long id = this.grid.cellToId(xOffset + x, 0, zOffset + z);
                this.gridFilters[x][z] = filter = Filters.fieldEquals(SpawnPosition.class, (String)"binId", (Object)id);
                filters[index++] = filter;
            }
        }
        this.shapes.setFilter(Filters.or(SpawnPosition.class, (ComponentFilter[])filters));
    }

    private Spatial createSpatial(EntityId id, DebugShape shape) {
        Material mat = GuiGlobals.getInstance().createMaterial(shape.getColor(), shape.hasStyle(4)).getMaterial();
        Geometry geom = null;
        switch (shape.getType()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                Arrow arrow = new Arrow(shape.getSize().toVector3f());
                geom = new Geometry("arrow:" + id, (Mesh)arrow);
                geom.setMaterial(mat);
                break;
            }
        }
        return geom;
    }

    private class ShapeContainer
    extends EntityContainer<ShapeView> {
        public ShapeContainer(EntityData ed) {
            super(ed, new Class[]{DebugShape.class, SpawnPosition.class});
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        public ShapeView[] getArray() {
            return (ShapeView[])super.getArray();
        }

        protected ShapeView addObject(Entity e) {
            log.info("add shape for:" + e.getId() + "  e:" + e);
            ShapeView object = new ShapeView(e);
            this.updateObject(object, e);
            return object;
        }

        protected void updateObject(ShapeView object, Entity e) {
            log.info("updateShapeView(" + e.getId() + ") pos:" + e.get(SpawnPosition.class));
            object.update();
        }

        protected void removeObject(ShapeView object, Entity e) {
            log.info("remove shape for:" + e.getId());
            object.release();
        }
    }

    private class ShapeView {
        private Entity entity;
        private SpawnPosition pos;
        private DebugShape shape;
        private Spatial spatial;

        public ShapeView(Entity entity) {
            this.entity = entity;
        }

        public void update() {
            if (this.spatial != null) {
                this.spatial.removeFromParent();
            }
            this.shape = (DebugShape)this.entity.get(DebugShape.class);
            this.spatial = DebugShapeViewState.this.createSpatial(this.entity.getId(), this.shape);
            this.pos = (SpawnPosition)this.entity.get(SpawnPosition.class);
            this.updateRelativePosition();
            DebugShapeViewState.this.root.attachChild(this.spatial);
        }

        public void updateRelativePosition() {
            Vec3d loc = this.pos.getLocation();
            loc = loc.subtract(DebugShapeViewState.this.centerWorld);
            this.spatial.setLocalTranslation(loc.toVector3f());
        }

        public void release() {
            if (this.spatial != null) {
                this.spatial.removeFromParent();
                this.spatial = null;
            }
        }
    }
}

