/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.web;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import mythruna.client.MythrunaConfig;
import mythruna.client.web.WebLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialMediaLinks {
    static Logger log = LoggerFactory.getLogger(SocialMediaLinks.class);
    public static final String DEFAULT_RESOURCE = "/default-social-media.json";
    public static final String MEDIA_FILE = "mythruna-social-media.json";
    public static final String WEB_RESOURCE = "https://www.mythruna.com/registry/mythruna-social-media.json";
    private static final long REFRESH_INTERVAL = 86400000L;
    private static List<WebLink> defaultLinks = new ArrayList<WebLink>();
    private static List<WebLink> webLinks;

    protected static final void setupDefaults() {
        defaultLinks.add(new WebLink("https://discord.gg/HdmFHhRy4w", "/Interface/social-media-discord.png", "Join Discord"));
        defaultLinks.add(new WebLink("https://www.patreon.com/c/pspeed42", "/Interface/social-media-patreon.png", "Patreon"));
        defaultLinks.add(new WebLink("https://www.youtube.com/@PaulSpeed42", "/Interface/social-media-youtube.png", "YouTube"));
        defaultLinks.add(new WebLink("https://bsky.app/profile/mythruna.bsky.social", "/Interface/social-media-bsky.png", "bsky"));
        defaultLinks.add(new WebLink("https://www.facebook.com/Mythruna", "/Interface/social-media-facebook.png", "Facebook"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<WebLink> getWebLinks() {
        List<WebLink> list = webLinks;
        synchronized (list) {
            if (!webLinks.isEmpty()) {
                return webLinks;
            }
            File disk = MythrunaConfig.getInstance().getConfigFile(MEDIA_FILE);
            long time = disk.lastModified();
            if (System.currentTimeMillis() - time < 86400000L) {
                try {
                    List<WebLink> fromDisk = SocialMediaLinks.load(disk);
                    log.info("loaded from disk:" + disk);
                    if (!fromDisk.isEmpty()) {
                        webLinks.addAll(fromDisk);
                    }
                    return webLinks;
                }
                catch (IOException e) {
                    log.error("Error loading:" + disk, (Throwable)e);
                }
            }
            try {
                URL u = new URL(WEB_RESOURCE);
                List<WebLink> fromWeb = SocialMediaLinks.load(u);
                log.info("loaded from web:" + fromWeb);
                if (!fromWeb.isEmpty()) {
                    webLinks.addAll(fromWeb);
                }
                SocialMediaLinks.store(fromWeb, disk);
                return webLinks;
            }
            catch (IOException e) {
                log.error("Error loading:https://www.mythruna.com/registry/mythruna-social-media.json", (Throwable)e);
                try {
                    webLinks = SocialMediaLinks.load(SocialMediaLinks.class.getResource(DEFAULT_RESOURCE));
                }
                catch (Exception e2) {
                    log.error("Error loading:/default-social-media.json", (Throwable)e2);
                    webLinks.addAll(defaultLinks);
                }
                return webLinks;
            }
        }
    }

    public static List<WebLink> load(URL u) throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        String json = Resources.toString((URL)u, (Charset)Charsets.UTF_8);
        TypeToken<List<WebLink>> resultType = new TypeToken<List<WebLink>>(){};
        return (List)gson.fromJson(json, (TypeToken)resultType);
    }

    public static List<WebLink> load(File file) throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        String json = Files.toString((File)file, (Charset)Charsets.UTF_8);
        TypeToken<List<WebLink>> resultType = new TypeToken<List<WebLink>>(){};
        return (List)gson.fromJson(json, (TypeToken)resultType);
    }

    public static void store(List<WebLink> links, File target) throws IOException {
        log.info("Writing:" + target.getCanonicalFile());
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        String json = gson.toJson(links);
        Files.write((CharSequence)json, (File)target, (Charset)Charsets.UTF_8);
    }

    static {
        SocialMediaLinks.setupDefaults();
        webLinks = new ArrayList<WebLink>();
    }
}

