/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.dnd;

import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.dnd.DragStatus;
import com.simsilica.lemur.dnd.Draggable;

public class DefaultDraggable
implements Draggable {
    private Vector2f start;
    private Spatial spatial;
    private Vector3f origin;
    private Vector3f xAxis;
    private Vector3f yAxis;
    private Vector2f currentLocation;

    public DefaultDraggable(Vector2f start, Spatial spatial, Vector3f origin, Vector3f xAxis, Vector3f yAxis) {
        this.start = start.clone();
        this.spatial = spatial;
        this.origin = origin.clone();
        this.xAxis = xAxis.clone();
        this.yAxis = yAxis.clone();
        this.currentLocation = start.clone();
    }

    public DefaultDraggable(ViewPort view, Spatial spatial, Vector2f start) {
        Camera cam = view.getCamera();
        Vector3f origin = spatial.getWorldTranslation();
        Vector3f screenPos = cam.getScreenCoordinates(origin);
        Vector2f xScreen = new Vector2f(screenPos.x + 1.0f, screenPos.y);
        Vector2f yScreen = new Vector2f(screenPos.x, screenPos.y + 1.0f);
        Vector3f xWorld = cam.getWorldCoordinates(xScreen, screenPos.z);
        Vector3f yWorld = cam.getWorldCoordinates(yScreen, screenPos.z);
        this.start = start.clone();
        this.spatial = spatial;
        this.origin = origin.clone();
        this.xAxis = xWorld.subtractLocal(origin);
        this.yAxis = yWorld.subtractLocal(origin);
        this.currentLocation = start.clone();
    }

    public Spatial getSpatial() {
        return this.spatial;
    }

    protected void updateTranslation() {
        float x = this.currentLocation.x - this.start.x;
        float y = this.currentLocation.y - this.start.y;
        Vector3f loc = this.origin.add(this.xAxis.mult(x)).addLocal(this.yAxis.mult(y));
        loc = this.spatial.getParent().worldToLocal(loc, loc);
        this.spatial.setLocalTranslation(loc);
    }

    @Override
    public void setLocation(float x, float y) {
        this.currentLocation.set(x, y);
        this.updateTranslation();
    }

    @Override
    public Vector2f getLocation() {
        return this.currentLocation;
    }

    @Override
    public void updateDragStatus(DragStatus status) {
    }

    @Override
    public void release() {
        this.spatial.removeFromParent();
    }
}

