#import "Common/ShaderLib/GLSLCompat.glsllib"
#import "Common/ShaderLib/MultiSample.glsllib"

uniform COLORTEXTURE m_Texture;
uniform DEPTHTEXTURE m_DepthTexture;

#if defined(HAS_NOISE_MAPE)
    #define NEED_TEXCOORD1
#endif

uniform vec4 m_CloudColor;
uniform vec4 m_BackgroundColor;
uniform float m_FadeDistance;
uniform float m_FadeMinimum;
uniform float m_Alpha;

uniform vec2 g_FrustumNearFar;

uniform float g_Time;

#ifdef HAS_NOISE_MAP
    uniform sampler2D m_NoiseMap;
#endif

//varying vec2 texCoord;
varying vec2 texCoord;

const float threshold = 0.5;
const float margin = 0.1;
const float rescale = 1.0 / (1.0 - threshold);

float getLayerSample( float baseTime, float innerTime, float layer ) {

    float time = mod(baseTime + innerTime, 7.0);
    //float scale = (1.0 + time) / 6.0;
    float scale = time / 7.0;

    scale = 1.0 - scale;
    //scale *= 5.0;
    scale *= 1.5;

    vec2 pos = texCoord;
    //pos.x += mod(g_Time, 5.0) * 0.1;

    pos = pos - vec2(0.5, 0.5);

    vec4 noiseOffset = texture2D(m_NoiseMap, vec2(0.5, layer));

    vec2 offset = noiseOffset.xy * 2.0 - vec2(1.0, 0.1);

    vec4 noise1 = texture2D(m_NoiseMap, vec2(0.5, 0.5) + pos * scale + offset);
    vec4 noise2 = texture2D(m_NoiseMap, vec2(0.5, 0.5) + pos * 4.0 * scale + offset);
    vec4 noise3 = texture2D(m_NoiseMap, vec2(0.5, 0.5) + pos * 8.0 * scale + offset);

    float value;
    //if( texCoord.x < 0.25 ) {
    //    value = noise1.r;
    //} else if( texCoord.x < 0.5 ) {
    //    value = noise1.r + (noise2.g * 2.0 - 1.0) * 0.25;
    //} else {
        value = noise1.r + (noise2.g * 2.0 - 1.0) * 0.25 + (noise2.b * 2.0 - 1.0) * 0.125;
    //}

    //value = (smoothstep(0.2, 0.25, value) * value - 0.2) * 1.25;
    value = (smoothstep(threshold, threshold + margin, value) * value - threshold) * rescale;

    // Let's add a little extra suppression towards the middle
    float d = length(pos) * scale;
    float centerFade = min(d, 0.1)/0.1;
    value *= centerFade;

    //float fade1 = smoothstep(5.0, 4.5, time);
    //float fade1 = smoothstep(5.0, 4.0, time);
    float fade1 = 1.0 - (max(0.0, time - 6.0)/1.0);
    float fade2 = min(time/3.0, 1.0); //smoothstep(0.0, 5.0, time);
    value *= fade1 * fade2; // + time / 5.0;

    return clamp(value, 0.0, 1.0);
}

float combineLayers( float layer1, float layer2 ) {
    //return mix(layer1, layer2 + layer1 * 0.1, layer2 + 0.5);
    if( layer2 > 0.5 ) {
        return layer2;
    } else if( layer2 > 0.0 ) {
        return mix(layer1, layer2, smoothstep(0.0, 1.0, layer2 / 0.5));
    }
    return layer1; // + layer2;
}

void main(){
    vec4 color = vec4(1.0);

    #ifdef HAS_NOISE_MAP
        //float time = mod(g_Time, 5.0);
        //
        //float scale = (1.0 + time) / 6.0;
        //
        //scale = 1.0 - scale;
        //
        //vec2 pos = texCoord;
        ////pos.x += mod(g_Time, 5.0) * 0.1;
        //
        //pos = pos - vec2(0.5, 0.5);
        //
        //vec4 noise1 = texture2D(m_NoiseMap, vec2(0.5, 0.5) + pos * scale);
        //vec4 noise2 = texture2D(m_NoiseMap, vec2(0.5, 0.5) + pos * 4.0 * scale);
        //vec4 noise3 = texture2D(m_NoiseMap, vec2(0.5, 0.5) + pos * 8.0 * scale);
        //
        //float value;
        ////if( texCoord.x < 0.25 ) {
        ////    value = noise1.r;
        ////} else if( texCoord.x < 0.5 ) {
        ////    value = noise1.r + (noise2.g * 2.0 - 1.0) * 0.25;
        ////} else {
        //    value = noise1.r + (noise2.g * 2.0 - 1.0) * 0.25 + (noise2.b * 2.0 - 1.0) * 0.125;
        ////}
        //
        ////value = (smoothstep(0.2, 0.25, value) * value - 0.2) * 1.25;
        //value = (smoothstep(threshold, threshold + margin, value) * value - threshold) * rescale;
        //
        //float fade1 = smoothstep(5.0, 4.5, time);
        //float fade2 = smoothstep(0.0, 0.5, time);
        //value *= fade1 * fade2;

        //float scaledTime = g_Time * 0.1; // 2.0;
        float scaledTime = g_Time * 3.0;

        float layerStep = 0.015;

        float value1 = getLayerSample(0.0, mod(scaledTime, 1.0), floor((scaledTime + 0.0)) * layerStep);
        float value2 = getLayerSample(1.0, mod(scaledTime, 1.0), floor((scaledTime - 1.0)) * layerStep);
        float value3 = getLayerSample(2.0, mod(scaledTime, 1.0), floor((scaledTime - 2.0)) * layerStep);
        float value4 = getLayerSample(3.0, mod(scaledTime, 1.0), floor((scaledTime - 3.0)) * layerStep);
        float value5 = getLayerSample(4.0, mod(scaledTime, 1.0), floor((scaledTime - 4.0)) * layerStep);
        float value6 = getLayerSample(5.0, mod(scaledTime, 1.0), floor((scaledTime - 5.0)) * layerStep);
        float value7 = getLayerSample(6.0, mod(scaledTime, 1.0), floor((scaledTime - 6.0)) * layerStep);
        //float value1 = getLayerSample(0.0, mod(scaledTime, 1.0), 0.2);
        //float value2 = getLayerSample(1.0, mod(scaledTime, 1.0), 0.2);
        //float value3 = getLayerSample(2.0, mod(scaledTime, 1.0), 0.2);
        //float value4 = getLayerSample(3.0, mod(scaledTime, 1.0), 0.2);
        //float value5 = getLayerSample(4.0, mod(scaledTime, 1.0), 0.2);

        float value;
        //if( texCoord.x < 0.4 ) {
        //    value = value1;
        //} else if( texCoord.x < 0.6 ) {
            //value = clamp(value1 + value2 + value3 + value4 + value5, 0.0, 1.0);

            value = 0;
            color = vec4(1.0, 1.0, 1.0, 1.0);
            //value += value2 * step(0.1, value2);
            //value += value3 * step(0.1, value3);
            //value += value4 * step(0.1, value4);
            //value += value5 * step(0.1, value5);
            if( value1 > 0.01 ) {
                value = combineLayers(value, value1); //mix(value, value2 + value * 0.1, value2 + 0.5);
            }
            if( value2 > 0.01 ) {
                value = combineLayers(value, value2); //mix(value, value2 + value * 0.1, value2 + 0.5);
                color = vec4(1.0, 1.0, 1.0, 1.0);
            }
            if( value3 > 0.01 ) {
                value = combineLayers(value, value3); //mix(value, value3 + value * 0.1, value3 + 0.5);
                color = vec4(1.0, 1.0, 1.0, 1.0);
            }
            if( value4 > 0.01 ) {
                value = combineLayers(value, value4); //mix(value, value4 + value * 0.1, value4 + 0.5);
                color = vec4(1.0, 1.0, 1.0, 1.0);
            }
            if( value5 > 0.01 ) {
                value = combineLayers(value, value5); //mix(value, value5 + value * 0.1, value5 + 0.5);
                color = vec4(1.0, 1.0, 1.0, 1.0);
            }
            if( value6 > 0.01 ) {
                value = combineLayers(value, value6); //mix(value, value5 + value * 0.1, value5 + 0.5);
                color = vec4(1.0, 1.0, 1.0, 1.0);
            }
            if( value7 > 0.01 ) {
                value = combineLayers(value, value7); //mix(value, value5 + value * 0.1, value5 + 0.5);
                color = vec4(1.0, 1.0, 1.0, 1.0);
            }

            //value = value / 10.0;
        //} else {
        //    value = value2;
        //}

        //color *= vec4(value, value, value, 1.0);

        float temperature = 0.75;
        //color = mix(vec4(temperature, temperature * 0.75, temperature, 1.0), vec4(0.0, 1.0, 1.0, 1.0), value);
        color = mix(m_BackgroundColor, m_CloudColor, value);

    #endif

    vec4 screenColor = getColor(m_Texture, texCoord);

    ////vec2 frustumNearFar=vec2(1.0, m_FadeDistance);
    //vec2 frustumNearFar=vec2(0.1, 1000.0);
    //float rawDepth = getDepth(m_DepthTexture,texCoord).r;
    ////float depth= (2.0 * frustumNearFar.x) / (frustumNearFar.y + frustumNearFar.x - rawDepth * (frustumNearFar.y-frustumNearFar.x));
    //float depth = (frustumNearFar.y - frustumNearFar.x) * rawDepth;
    //
    //float fade = min(1.0, depth / m_FadeDistance);


    float zBuffer = getDepth(m_DepthTexture, texCoord).r;

    //
    // z_buffer_value = a + b / z;
    //
    // Where:
    //  a = zFar / ( zFar - zNear )
    //  b = zFar * zNear / ( zNear - zFar )
    //  z = distance from the eye to the object
    //
    // Which means:
    // zb - a = b / z;
    // z * (zb - a) = b
    // z = b / (zb - a)
    //
    float a = g_FrustumNearFar.y / (g_FrustumNearFar.y - g_FrustumNearFar.x);
    float b = g_FrustumNearFar.y * g_FrustumNearFar.x / (g_FrustumNearFar.x - g_FrustumNearFar.y);
    float z = b / (zBuffer - a);


    //float depth = rawDepth;

    //depth = depth * depth;

    //depth = step(0.95, depth);

    //depth = smoothstep(0.0, 1.0, depth);

    //depth = fade;
    float minDist = m_FadeDistance * 0.5;
    float depth = (z - minDist)/(m_FadeDistance - minDist);
    //depth = min(1.0, depth);
    depth = m_FadeMinimum + smoothstep(0, 1.0, depth) * (1.0 - m_FadeMinimum);

    //gl_FragColor = mix(color, screenColor, depth);
    gl_FragColor = mix(screenColor, color, depth * m_Alpha);
    //gl_FragColor = vec4(depth, depth, depth, 1.0);
    //gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
}
