/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MythrunaConfig {
    public static final String CONFIG_FILE = "mythruna-client.config";
    public static final String DEFAULT_WORLD_LIBRARY = "worlds";
    public static final String SETTING_OBJECT_NAMES_ENABLED = "settings.objectNames.enabled";
    public static final String SETTING_CHARACTER_NAMES_ENABLED = "settings.characterNames.enabled";
    public static final String SETTING_PLAYER_NAMES_ENABLED = "settings.playerNames.enabled";
    public static final String SETTING_STATUS_TEXT_ENABLED = "settings.statusText.enabled";
    public static final String SETTING_DEBUG_TEXT_ENABLED = "settings.debugText.enabled";
    public static final String SETTING_CONSOLE_FADE_TIME = "settings.console.fadeTime";
    public static final String SETTING_CONSOLE_TEXT_SCALE = "settings.console.textScale";
    public static final String SETTING_CONSOLE_HISTORY_SIZE = "settings.console.historySize";
    public static final String SETTING_DEBUG_HUD_ENABLED = "settings.debugHud.enabled";
    public static final String SETTINGS_LEGACY_DIALOG_ENABLED = "settings.legacy.dialog.enabled";
    public static final String SETTINGS_DISPLAY_SETTINGS = "settings.displaySettings";
    static Logger log = LoggerFactory.getLogger(MythrunaConfig.class);
    private transient File configFile;
    private File configDir;
    private String worldLibrary;
    private Map<String, Object> startupSettings;
    private static MythrunaConfig instance;

    private MythrunaConfig() {
    }

    protected void initializeDefaults() {
        this.worldLibrary = DEFAULT_WORLD_LIBRARY;
        this.startupSettings = new HashMap<String, Object>();
    }

    protected boolean upgrade() {
        boolean changed = false;
        if (this.startupSettings == null) {
            this.startupSettings = new HashMap<String, Object>();
            changed = true;
        }
        return changed;
    }

    public File getWorldLibrary() {
        return new File(this.configDir, this.worldLibrary);
    }

    public File getConfigFile(String file) {
        return new File(this.configDir, file);
    }

    public <T> T getStartupSetting(String key, T defaultValue) {
        if (this.startupSettings.containsKey(key)) {
            return (T)this.startupSettings.get(key);
        }
        return defaultValue;
    }

    public int getStartupSettingInt(String key, int defaultValue) {
        if (!this.startupSettings.containsKey(key)) {
            return defaultValue;
        }
        Number result = this.getStartupSetting(key, null);
        if (result == null) {
            return defaultValue;
        }
        return result.intValue();
    }

    public double getStartupSettingDouble(String key, double defaultValue) {
        if (!this.startupSettings.containsKey(key)) {
            return defaultValue;
        }
        Number result = this.getStartupSetting(key, null);
        if (result == null) {
            return defaultValue;
        }
        return result.doubleValue();
    }

    public Map<String, Object> getStartupSettings() {
        return this.startupSettings;
    }

    public static MythrunaConfig getInstance() {
        String userHome;
        if (instance != null) {
            return instance;
        }
        File f = new File(CONFIG_FILE);
        if (!f.exists() && !(f = new File(new File(userHome = System.getProperty("user.home")) + "/.mythruna2/mythruna-client.config")).getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        if (f.exists()) {
            try {
                instance = MythrunaConfig.load(f);
                if (instance.upgrade()) {
                    MythrunaConfig.store(instance, f);
                }
            }
            catch (Exception e) {
                log.error("Error loading config file.  Initializing defaults.", (Throwable)e);
            }
        }
        if (instance == null) {
            instance = new MythrunaConfig();
            instance.initializeDefaults();
            if (!f.exists()) {
                try {
                    MythrunaConfig.store(instance, f);
                }
                catch (Exception e) {
                    log.error("Error storing sample config file", (Throwable)e);
                }
            }
        }
        if (MythrunaConfig.instance.configDir == null && f.exists()) {
            try {
                MythrunaConfig.instance.configDir = f.getCanonicalFile().getParentFile();
                if (!MythrunaConfig.instance.configDir.exists()) {
                    MythrunaConfig.instance.configDir.mkdirs();
                }
            }
            catch (IOException e) {
                log.error("Error getting canonical file for:" + f, (Throwable)e);
            }
        }
        if (MythrunaConfig.instance.configDir == null) {
            MythrunaConfig.instance.configDir = new File(".");
        }
        log.info("Using config dir:" + MythrunaConfig.instance.configDir);
        if (f.exists()) {
            MythrunaConfig.instance.configFile = f;
        }
        return instance;
    }

    public static void save() {
        MythrunaConfig instance = MythrunaConfig.getInstance();
        if (instance.configFile == null) {
            throw new RuntimeException("No config file set");
        }
        MythrunaConfig.store(instance, instance.configFile);
    }

    public static MythrunaConfig load(File f) {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        try {
            String json = Files.toString((File)f, (Charset)Charsets.UTF_8);
            return (MythrunaConfig)gson.fromJson(json, MythrunaConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading:" + f, e);
        }
    }

    public static void store(MythrunaConfig config, File f) {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        try {
            log.info("Storing:" + f);
            String json = gson.toJson((Object)config);
            Files.write((CharSequence)json, (File)f, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Error storing:" + f, e);
        }
    }

    public static String toJson(Object o) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        return gson.toJson(o);
    }

    public static <T> T fromJson(String json, Class<T> type) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        return (T)gson.fromJson(json, type);
    }
}

