/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.api.ReaderWriterProvider;
import com.fasterxml.jackson.jr.ob.api.ValueWriter;
import com.fasterxml.jackson.jr.ob.impl.JSONWriter;
import com.google.common.base.MoreObjects;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import mythruna.text.VersionedExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenAnnotation {
    static Logger log = LoggerFactory.getLogger(ScreenAnnotation.class);
    public static final ColorRGBA DEFAULT_COLOR = new ColorRGBA(0.09803922f, 0.078431375f, 0.06666667f, 0.7f);
    private static final JSON MAPPER = JSON.std.with((ReaderWriterProvider)new CustomReaderWriterProvider());
    private static final Pattern PARAMETERS = Pattern.compile("(?<!\\\\)\\$(\\w+)|\\$\\{(.*?)\\}");
    private VersionedExpression text;
    private VersionedHolder<String> font = new VersionedHolder((Object)"Interface/Fonts/Default.fnt");
    private VersionedHolder<Float> scale = new VersionedHolder((Object)Float.valueOf(1.0f));
    private VersionedHolder<Float> angle = new VersionedHolder((Object)Float.valueOf(0.0f));
    private VersionedHolder<ColorRGBA> color = new VersionedHolder((Object)DEFAULT_COLOR);
    private VersionedHolder<ColorRGBA> shadowColor = new VersionedHolder(null);
    private VersionedHolder<Vector2f> anchor = new VersionedHolder((Object)new Vector2f(1.0f, -1.0f));
    private VersionedHolder<Boolean> enabled = new VersionedHolder((Object)Boolean.TRUE);

    private ScreenAnnotation() {
        this(null);
    }

    public ScreenAnnotation(String text) {
        this.text = new VersionedExpression(text);
    }

    public void setEnabled(Boolean enabled) {
        this.enabled.updateObject((Object)enabled);
    }

    public Boolean getEnabled() {
        return (Boolean)this.enabled.getObject();
    }

    public VersionedReference<Boolean> createEnabledRef() {
        return this.enabled.createReference();
    }

    public void setFont(String font) {
        this.font.updateObject((Object)font);
    }

    public String getFont() {
        return (String)this.font.getObject();
    }

    public VersionedReference<String> createFontRef() {
        return this.font.createReference();
    }

    public void setScale(float scale) {
        this.scale.updateObject((Object)Float.valueOf(scale));
    }

    public float getScale() {
        return ((Float)this.scale.getObject()).floatValue();
    }

    public VersionedReference<Float> createScaleRef() {
        return this.scale.createReference();
    }

    public void setAngle(float angle) {
        this.angle.updateObject((Object)Float.valueOf(angle));
    }

    public float getAngle() {
        return ((Float)this.angle.getObject()).floatValue();
    }

    public VersionedReference<Float> createAngleRef() {
        return this.angle.createReference();
    }

    public void setAnchor(Vector2f anchor) {
        this.anchor.updateObject((Object)anchor);
    }

    public Vector2f getAnchor() {
        return (Vector2f)this.anchor.getObject();
    }

    public VersionedReference<Vector2f> createAnchorRef() {
        return this.anchor.createReference();
    }

    public void setColor(ColorRGBA color) {
        this.color.updateObject((Object)(color == null ? DEFAULT_COLOR : color));
    }

    public ColorRGBA getColor() {
        return (ColorRGBA)this.color.getObject();
    }

    public VersionedReference<ColorRGBA> createColorRef() {
        return this.color.createReference();
    }

    public void setShadowColor(ColorRGBA shadowColor) {
        this.shadowColor.updateObject((Object)shadowColor);
    }

    public ColorRGBA getShadowColor() {
        return (ColorRGBA)this.shadowColor.getObject();
    }

    public VersionedReference<ColorRGBA> createShadowColorRef() {
        return this.shadowColor.createReference();
    }

    public boolean update(Map<String, Supplier<Object>> values) {
        return this.text.update(values);
    }

    public void setExpression(String expression) {
        this.text.setExpression(expression);
    }

    public String getExpression() {
        return this.text.getExpression();
    }

    public String getText() {
        return this.text.getObject();
    }

    public VersionedReference<String> createValueRef() {
        return this.text.createReference();
    }

    public String toJson() {
        try {
            return MAPPER.asString((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException("Error serializing:" + this, e);
        }
    }

    public static ScreenAnnotation fromJson(String json) {
        try {
            return (ScreenAnnotation)MAPPER.beanFrom(ScreenAnnotation.class, (Object)json);
        }
        catch (IOException e) {
            throw new RuntimeException("Error deserializing:" + json, e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("text", (Object)this.text).add("font", this.font.getObject()).add("angle", this.angle.getObject()).add("anchor", this.anchor.getObject()).add("color", this.color.getObject()).toString();
    }

    private static class CustomReaderWriterProvider
    extends ReaderWriterProvider {
        private CustomReaderWriterProvider() {
        }

        public ValueWriter findValueWriter(JSONWriter writeContext, Class<?> type) {
            if (type == ColorRGBA.class) {
                return new ColorWriter();
            }
            return null;
        }
    }

    private static class ColorWriter
    implements ValueWriter {
        private ColorWriter() {
        }

        public Class<?> valueType() {
            return ColorRGBA.class;
        }

        public void writeValue(JSONWriter context, JsonGenerator g, Object v) throws IOException {
            ColorRGBA value = (ColorRGBA)v;
            g.writeStartObject();
            g.writeNumberField("r", value.r);
            g.writeNumberField("g", value.g);
            g.writeNumberField("b", value.b);
            g.writeNumberField("a", value.a);
            g.writeEndObject();
        }
    }
}

