/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.object;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.scene.Spatial;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.bpos.ChildPositionTransition3d;
import com.simsilica.crig.CharacterRig;
import com.simsilica.crig.es.AnimationConfig;
import com.simsilica.crig.es.LayerConfig;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.trans.TransitionBuffer;
import java.util.Objects;
import java.util.function.Consumer;
import mythruna.client.GameSessionState;
import mythruna.client.net.TimeState;
import mythruna.client.view.object.Model;
import mythruna.client.view.object.ModelCounts;
import mythruna.client.view.object.ModelViewState;
import mythruna.client.view.object.RigModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterAnimationState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(CharacterAnimationState.class);
    private EntityData ed;
    private ModelViewState models;
    private TimeState timeSource;
    private CharacterContainer characters;
    private ModelCounts counts;

    protected void initialize(Application app) {
        this.ed = ((GameSessionState)this.getState(GameSessionState.class, true)).getEntityData();
        this.models = (ModelViewState)this.getState(ModelViewState.class, true);
        this.timeSource = (TimeState)this.getState(TimeState.class, true);
        this.characters = new CharacterContainer(this.ed);
        this.counts = this.models.getModelCounts();
        this.counts.createView("Chars");
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.characters.start();
    }

    public void update(float tpf) {
        long time = this.timeSource.getTime();
        this.characters.update();
        for (AnimatedMob mob : this.characters.getArray()) {
            mob.update(time);
        }
        this.counts.updateCount("Chars", this.characters.size());
    }

    protected void onDisable() {
        this.characters.stop();
    }

    private class CharacterContainer
    extends EntityContainer<AnimatedMob> {
        public CharacterContainer(EntityData ed) {
            super(ed, new Class[]{BodyPosition.class, AnimationConfig.class});
        }

        public AnimatedMob[] getArray() {
            return (AnimatedMob[])super.getArray();
        }

        protected AnimatedMob addObject(Entity e) {
            AnimatedMob am = new AnimatedMob(e);
            this.updateObject(am, e);
            return am;
        }

        protected void updateObject(AnimatedMob object, Entity e) {
            object.update((AnimationConfig)e.get(AnimationConfig.class));
        }

        protected void removeObject(AnimatedMob object, Entity e) {
            object.release();
        }
    }

    private class AnimatedMob
    implements Consumer<Model> {
        private Entity animEntity;
        private AnimationConfig config;
        private EntityId target;
        private BodyPosition bpos;
        private TransitionBuffer<ChildPositionTransition3d> buffer;
        private Vec3d times = new Vec3d();
        private Quatd mixes = new Quatd();
        private RigModel model;
        private VersionedReference<Spatial> spatialRef;
        private CharacterRig rig;

        public AnimatedMob(Entity animEntity) {
            this.animEntity = animEntity;
            this.config = (AnimationConfig)animEntity.get(AnimationConfig.class);
            this.bpos = (BodyPosition)animEntity.get(BodyPosition.class);
            this.bpos.initialize(animEntity.getId(), 12);
            this.buffer = this.bpos.getBuffer();
        }

        @Override
        public void accept(Model model) {
            if (model == null || model instanceof RigModel) {
                this.setModel((RigModel)model);
            }
        }

        protected void setModel(RigModel model) {
            if (this.model == model) {
                return;
            }
            this.model = model;
            if (model != null) {
                this.spatialRef = model.createSpatialRef();
                this.rig = model.getCharacterRig();
            } else {
                this.rig = null;
                this.spatialRef = null;
            }
        }

        protected void setTarget(EntityId target) {
            if (Objects.equals(this.target, target)) {
                return;
            }
            if (this.target != null) {
                CharacterAnimationState.this.models.removeModelWatch(this.target, this);
            }
            this.target = target;
            if (this.target != null) {
                CharacterAnimationState.this.models.addModelWatch(this.target, this);
            }
        }

        public void update(AnimationConfig config) {
            this.config = config;
            this.times.set(-1.0, -1.0, -1.0);
            this.mixes.set(-1.0, -1.0, -1.0, -1.0);
            this.setTarget(config.getTarget());
        }

        public void update(long time) {
            if (this.spatialRef != null && this.spatialRef.update()) {
                this.rig = this.model.getCharacterRig();
            }
            if (this.rig == null) {
                return;
            }
            ChildPositionTransition3d trans = (ChildPositionTransition3d)this.buffer.getTransition(time);
            if (trans != null) {
                Quatd quat = trans.getRotation(time, true);
                this.updateMixes(quat);
                Vec3d start = trans.getStartPosition();
                if (start == null) {
                    return;
                }
                Vec3d end = trans.getEndPosition();
                for (int i = 0; i < 3; ++i) {
                    double v2;
                    double v1 = start.get(i);
                    if (v1 == (v2 = end.get(i)) || !(Math.abs(v2 - v1) > 0.5)) continue;
                    start.set(i, v2);
                }
                Vec3d pos = trans.getPosition(time, true);
                this.updateTimes(pos);
            }
        }

        protected void updateMixes(Quatd q) {
            String action;
            double val;
            int mixIndex = 0;
            for (LayerConfig layerConfig : this.config.getLayers()) {
                val = q.get(mixIndex);
                if (this.mixes.get(mixIndex) != val) {
                    this.mixes.set(mixIndex, val);
                    action = layerConfig.getAction(val);
                    if (log.isDebugEnabled()) {
                        log.debug("Setting layer action:" + action);
                    }
                    this.rig.setLayerAction(layerConfig.getLayer(), action);
                }
                ++mixIndex;
            }
            for (LayerConfig layerConfig : this.config.getMixes()) {
                val = q.get(mixIndex);
                if (this.mixes.get(mixIndex) == val) continue;
                this.mixes.set(mixIndex, val);
                action = layerConfig.getBlendName();
                this.rig.setMix(action, val);
            }
        }

        protected void updateTimes(Vec3d v) {
            int layerIndex = 0;
            for (LayerConfig layer : this.config.getLayers()) {
                double val = v.get(layerIndex);
                double orig = this.rig.getTime(layer.getLayer());
                this.times.set(layerIndex, val);
                this.rig.setTime(layer.getLayer(), val);
            }
        }

        public void release() {
            this.setTarget(null);
        }
    }
}

