/*
 * Decompiled with CFR 0.152.
 */
package mythruna.text;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextUtils {
    static Logger log = LoggerFactory.getLogger(TextUtils.class);

    public static byte[] compress(String text) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(bOut)));){
            out.writeBoolean(text != null);
            if (text != null) {
                out.writeUTF(text);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error compressing text", e);
        }
        return bOut.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String decompress(byte[] data) {
        ByteArrayInputStream bIn = new ByteArrayInputStream(data);
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(new GZIPInputStream(bIn)));){
            boolean b = in.readBoolean();
            if (b) {
                String string = in.readUTF();
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Error decompressing text", e);
        }
    }
}

