/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.Attributes;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.StyleAttribute;
import com.simsilica.lemur.style.StyleDefaults;
import com.simsilica.lemur.style.Styles;

public class Container
extends Panel {
    public static final String ELEMENT_ID = "container";

    public Container() {
        this(null, true, new ElementId(ELEMENT_ID), null);
    }

    public Container(GuiLayout layout) {
        this(layout, true, new ElementId(ELEMENT_ID), null);
    }

    public Container(String style) {
        this(null, true, new ElementId(ELEMENT_ID), style);
    }

    public Container(ElementId elementId) {
        this(null, true, elementId, null);
    }

    public Container(ElementId elementId, String style) {
        this(null, true, elementId, style);
    }

    public Container(GuiLayout layout, ElementId elementId) {
        this(layout, true, elementId, null);
    }

    public Container(GuiLayout layout, String style) {
        this(layout, true, new ElementId(ELEMENT_ID), style);
    }

    public Container(GuiLayout layout, ElementId elementId, String style) {
        this(layout, true, elementId, style);
    }

    protected Container(GuiLayout layout, boolean applyStyles, ElementId elementId, String style) {
        super(false, elementId, style);
        if (applyStyles) {
            Styles styles = GuiGlobals.getInstance().getStyles();
            styles.applyStyles((Object)this, elementId, style);
        }
        if (layout != null) {
            this.setLayout(layout);
        }
        if (applyStyles && this.getLayout() == null) {
            this.setLayout(new SpringGridLayout());
        }
    }

    @StyleDefaults(value="container")
    public static void initializeDefaultStyles(Attributes attrs) {
        attrs.set("layout", new SpringGridLayout(), false);
    }

    public <T extends Node> T addChild(T child, Object ... constraints) {
        this.getLayout().addChild(child, constraints);
        return child;
    }

    public void removeChild(Node child) {
        this.getLayout().removeChild(child);
    }

    public void clearChildren() {
        this.getLayout().clearChildren();
    }

    public Spatial detachChildAt(int index) {
        Spatial child = this.getChild(index);
        if (child instanceof Node && this.getLayout().getChildren().contains((Node)child)) {
            this.removeChild((Node)child);
            return child;
        }
        return super.detachChildAt(index);
    }

    @StyleAttribute(value="layout", lookupDefault=false)
    public void setLayout(GuiLayout layout) {
        ((GuiControl)this.getControl(GuiControl.class)).setLayout(layout);
    }

    public GuiLayout getLayout() {
        return ((GuiControl)this.getControl(GuiControl.class)).getLayout();
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[layout=" + this.getLayout() + ", elementId=" + this.getElementId() + "]";
    }
}

