/*
 * Decompiled with CFR 0.152.
 */
package mythruna.assembly.db;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubassemblyId {
    static Logger log = LoggerFactory.getLogger(SubassemblyId.class);
    public static final String TYPE = "asm";
    public static final String EXTENSION = ".asm";
    private long id;

    private SubassemblyId() {
    }

    public SubassemblyId(long id) {
        this.id = id;
    }

    public static SubassemblyId fromString(String s) {
        return new SubassemblyId(Long.parseUnsignedLong(s, 16));
    }

    public static SubassemblyId fromFileName(String s) {
        if (!s.endsWith(EXTENSION)) {
            throw new IllegalArgumentException("String is not in filename form, no .asm extension:" + s);
        }
        s = s.substring(0, s.length() - 3);
        return SubassemblyId.fromString(s);
    }

    public long getId() {
        return this.id;
    }

    public String toIdString() {
        return String.format("%x", this.id);
    }

    public String toFileName() {
        return String.format("%x%s", this.id, EXTENSION);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SubassemblyId other = (SubassemblyId)o;
        return other.id == this.id;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id:" + this.id + "]";
    }
}

