/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.time;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeInterval
implements Cloneable {
    static Logger log = LoggerFactory.getLogger(TimeInterval.class);
    private static final Pattern TIME_PATTERN = Pattern.compile("((\\d{1,})/)?((\\d{1,2})/)?((\\d{1,2})\\s+)?(\\d{1,2}):(\\d{2})");
    private static final long MINS_PER_HOUR = 60L;
    private static final long MINS_PER_DAY = 1440L;
    private static final long MINS_PER_MONTH = 40320L;
    private static final long MINS_PER_YEAR = 161280L;
    private long intervalMinutes;

    public TimeInterval() {
    }

    public TimeInterval(int year, int month, int day) {
        this(year, month, day, 0, 0);
    }

    public TimeInterval(int year, int month, int day, int hours, int minutes) {
        this.intervalMinutes = (long)year * 161280L;
        this.intervalMinutes += (long)month * 40320L;
        this.intervalMinutes += (long)day * 1440L;
        this.intervalMinutes += (long)hours * 60L;
        this.intervalMinutes += (long)minutes;
    }

    public static TimeInterval parseInterval(String s) {
        Matcher m = TIME_PATTERN.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid world time format:" + s);
        }
        int year = m.group(2) != null ? Integer.parseInt(m.group(2)) : 0;
        int month = m.group(4) != null ? Integer.parseInt(m.group(4)) : 0;
        int days = m.group(6) != null ? Integer.parseInt(m.group(6)) : 0;
        int hours = m.group(7) != null ? Integer.parseInt(m.group(7)) : 0;
        int minutes = m.group(8) != null ? Integer.parseInt(m.group(8)) : 0;
        return new TimeInterval(year, month, days, hours, minutes);
    }

    public long getTotalSeconds() {
        return this.intervalMinutes * 60L;
    }

    public int getYears() {
        return (int)(this.intervalMinutes / 161280L);
    }

    public int getMonths() {
        return (int)(this.intervalMinutes % 161280L / 40320L);
    }

    public int getDays() {
        return (int)(this.intervalMinutes % 40320L / 1440L);
    }

    public int getHours() {
        return (int)(this.intervalMinutes % 1440L / 60L);
    }

    public int getMinutes() {
        return (int)(this.intervalMinutes % 60L);
    }

    public String asTimeString() {
        int minutes = this.getMinutes();
        int hours = this.getHours();
        int days = this.getDays();
        int months = this.getMonths();
        int years = this.getYears();
        StringBuilder sb = new StringBuilder();
        if (years > 0) {
            sb.append(String.format("%03d/", years));
        }
        if (months > 0 || sb.length() > 0) {
            sb.append(String.format("%d/", months));
        }
        if (days > 0 || sb.length() > 0) {
            sb.append(String.format("%02d ", days));
        }
        sb.append(String.format("%02d:%02d", hours, minutes));
        return sb.toString();
    }

    public String toString() {
        int minutes = this.getMinutes();
        int hours = this.getHours();
        int days = this.getDays();
        int months = this.getMonths();
        int years = this.getYears();
        StringBuilder sb = new StringBuilder();
        if (years > 0) {
            sb.append(String.format("%d yrs, ", years));
        }
        if (months > 0 || sb.length() > 0) {
            sb.append(String.format("%d months, ", months));
        }
        if (days > 0 || sb.length() > 0) {
            sb.append(String.format("%d days, ", days));
        }
        sb.append(String.format("%02d:%02d", hours, minutes));
        return sb.toString();
    }
}

