/*
 * Decompiled with CFR 0.152.
 */
package mythruna.text;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import mythruna.text.AbstractTextDb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTextDb
extends AbstractTextDb {
    static Logger log = LoggerFactory.getLogger(ResourceTextDb.class);
    private String root;

    public ResourceTextDb(String root) {
        this.root = root == null ? "" : root;
    }

    @Override
    protected String load(String location) {
        URL u = this.getClass().getResource("/" + this.root + "/" + location);
        log.info("Try 1:" + u);
        if (u == null) {
            u = this.getClass().getResource(this.root + "/" + location);
            log.info("Try 2:" + u);
        }
        if (u == null) {
            return null;
        }
        try {
            return Resources.toString((URL)u, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading resource:" + u, e);
        }
    }
}

