/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app.state;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.StateTiming;
import com.jme3.renderer.RenderManager;
import com.jme3.util.SafeArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppStateManager {
    private static final Logger logger = Logger.getLogger(AppStateManager.class.getName());
    private final SafeArrayList<AppState> initializing = new SafeArrayList<AppState>(AppState.class);
    private final SafeArrayList<AppState> states = new SafeArrayList<AppState>(AppState.class);
    private final SafeArrayList<AppState> terminating = new SafeArrayList<AppState>(AppState.class);
    private final ConcurrentMap<String, AppState> stateIndex = new ConcurrentHashMap<String, AppState>();
    private final Application app;
    private StateTiming timing;

    public AppStateManager(Application app) {
        this.app = app;
    }

    public void setStateTiming(StateTiming timing) {
        this.timing = timing;
    }

    public StateTiming getStateTiming() {
        return this.timing;
    }

    public Application getApplication() {
        return this.app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AppState[] getInitializing() {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            return this.initializing.getArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AppState[] getTerminating() {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            return this.terminating.getArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AppState[] getStates() {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            return this.states.getArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attach(AppState state) {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            if (state.getId() != null && this.stateIndex.putIfAbsent(state.getId(), state) != null) {
                throw new IllegalArgumentException("ID:" + state.getId() + " is already being used by another state:" + this.stateIndex.get(state.getId()));
            }
            if (!this.states.contains(state) && !this.initializing.contains(state)) {
                state.stateAttached(this);
                this.initializing.add(state);
                return true;
            }
            return false;
        }
    }

    public void attachAll(AppState ... states) {
        this.attachAll(Arrays.asList(states));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachAll(Iterable<AppState> states) {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            for (AppState state : states) {
                this.attach(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean detach(AppState state) {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            this.stateIndex.values().remove(state);
            if (this.states.contains(state)) {
                state.stateDetached(this);
                this.states.remove(state);
                this.terminating.add(state);
                return true;
            }
            if (this.initializing.contains(state)) {
                state.stateDetached(this);
                this.initializing.remove(state);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasState(AppState state) {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            return this.states.contains(state) || this.initializing.contains(state);
        }
    }

    public <T extends AppState> T getState(Class<T> stateClass) {
        return this.getState(stateClass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AppState> T getState(Class<T> stateClass, boolean failOnMiss) {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            AppState[] array;
            for (AppState state : array = this.getStates()) {
                if (!stateClass.isAssignableFrom(state.getClass())) continue;
                return (T)state;
            }
            for (AppState state : array = this.getInitializing()) {
                if (!stateClass.isAssignableFrom(state.getClass())) continue;
                return (T)state;
            }
        }
        if (failOnMiss) {
            throw new IllegalArgumentException("State not found for:" + stateClass);
        }
        return null;
    }

    public <T extends AppState> T getState(String id, Class<T> stateClass) {
        return (T)((AppState)stateClass.cast(this.stateIndex.get(id)));
    }

    public boolean hasState(String id) {
        return this.stateIndex.containsKey(id);
    }

    public <T extends AppState> T stateForId(String id, Class<T> stateClass) {
        T result = this.getState(id, stateClass);
        if (result == null) {
            throw new IllegalArgumentException("State not found for:" + id);
        }
        return (T)((AppState)stateClass.cast(result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializePending() {
        AppState[] array = this.getInitializing();
        if (array.length == 0) {
            return;
        }
        AppState[] appStateArray = this.states;
        synchronized (this.states) {
            List<AppState> transfer = Arrays.asList(array);
            this.states.addAll(transfer);
            this.initializing.removeAll(transfer);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (AppState state : array) {
                long start = System.nanoTime();
                state.initialize(this, this.app);
                long end = System.nanoTime();
                logger.log(Level.INFO, "initialized: {0} in {1} ms", new Object[]{state, (double)(end - start) / 1000000.0});
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminatePending() {
        AppState[] array = this.getTerminating();
        if (array.length == 0) {
            return;
        }
        for (AppState state : array) {
            state.cleanup();
            if (this.timing == null) continue;
            this.timing.remove(state);
        }
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            this.terminating.removeAll(Arrays.asList(array));
        }
    }

    public void update(float tpf) {
        this.terminatePending();
        this.initializePending();
        try {
            AppState[] array;
            if (this.timing != null) {
                this.timing.startFrame();
            }
            for (AppState state : array = this.getStates()) {
                if (state.isEnabled()) {
                    if (this.app.getAppProfiler() != null) {
                        this.app.getAppProfiler().appSubStep(state.getClass().getSimpleName());
                    }
                    if (this.timing != null) {
                        try (StateTiming.TimingInfo info = this.timing.trackUpdate(state);){
                            state.update(tpf);
                            continue;
                        }
                    }
                    state.update(tpf);
                    continue;
                }
                if (this.timing == null) continue;
                this.timing.clearUpdate(state);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("checked exceptions suck", e);
        }
        finally {
            if (this.timing != null) {
                this.timing.endFrame();
            }
        }
    }

    public void render(RenderManager rm) {
        AppState[] array;
        for (AppState state : array = this.getStates()) {
            if (!state.isEnabled()) continue;
            if (this.app.getAppProfiler() != null) {
                this.app.getAppProfiler().appSubStep(state.getClass().getSimpleName());
            }
            state.render(rm);
        }
    }

    public void postRender() {
        AppState[] array;
        for (AppState state : array = this.getStates()) {
            if (!state.isEnabled()) continue;
            if (this.app.getAppProfiler() != null) {
                this.app.getAppProfiler().appSubStep(state.getClass().getSimpleName());
            }
            state.postRender();
        }
    }

    public void cleanup() {
        AppState[] array;
        for (AppState state : array = this.getStates()) {
            state.cleanup();
        }
    }
}

