/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.mblock.db.CellArrayStorage;
import com.simsilica.mworld.io.CellArrayProtocol;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCellArrayStorage
implements CellArrayStorage {
    static Logger log = LoggerFactory.getLogger(DefaultCellArrayStorage.class);
    private File root;
    private HashFunction crc32 = Hashing.crc32();
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public DefaultCellArrayStorage(File root) {
        this.root = root;
    }

    protected File idToFile(long id) {
        String name = String.format("%016x", id);
        String prefix = name.charAt(0) + "" + name.charAt(1) + "/" + name.charAt(2) + "" + name.charAt(3);
        return new File(this.root, prefix + "/" + name + ".ca");
    }

    public CellArray apply(CellArrayId id) {
        return this.get(id);
    }

    public CellArray get(CellArrayId id) {
        File f = this.idToFile(id.getId());
        if (!f.exists()) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            CellArray cellArray = this.readCellArray(f);
            return cellArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading:" + id, e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean exists(CellArrayId id) {
        File f = this.idToFile(id.getId());
        return f.exists();
    }

    protected int sizeHash(CellArray array) {
        int x = array.getSizeX() - 1;
        int y = array.getSizeY() - 1;
        int z = array.getSizeZ() - 1;
        int result = x | y << 5 | z << 10;
        return result & 0xFFFF;
    }

    protected long calculateBaseId(byte[] bytes, CellArray array) {
        HashCode hash = this.crc32.hashBytes(bytes);
        long sizeHash = this.sizeHash(array);
        long hashId = (long)hash.asInt() & 0xFFFFFFFFL;
        long baseId = hashId << 31 ^ sizeHash << 16;
        return baseId;
    }

    public CellArrayId store(CellArray array) {
        assert (array.getSizeX() != 0);
        assert (array.getSizeY() != 0);
        assert (array.getSizeZ() != 0);
        byte[] bytes = CellArrayProtocol.toBytes(array);
        CellArray test = CellArrayProtocol.fromBytes(bytes);
        assert (Objects.equals(test.getSize(), array.getSize()));
        long baseId = this.calculateBaseId(bytes, array);
        this.lock.writeLock().lock();
        try {
            long actualId = this.storeBytes(baseId, bytes);
            CellArrayId cellArrayId = new CellArrayId(actualId);
            return cellArrayId;
        }
        catch (IOException e) {
            throw new RuntimeException("Error storing cells:" + array, e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void logBytes(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            if (i > 0 && i % 32 == 0) {
                sb.append("\n");
            } else if (i > 0) {
                sb.append(" ");
            }
            sb.append(String.format("%x", bytes[i]));
        }
        log.info(sb.toString());
    }

    protected long storeBytes(long baseId, byte[] bytes) throws IOException {
        long result = baseId;
        int attempts = 0;
        while (attempts >= 0) {
            File f = this.idToFile(result);
            if (!f.exists()) {
                File dir = f.getParentFile();
                if (!dir.exists()) {
                    log.info("Making dirs:" + dir);
                    dir.mkdirs();
                }
                log.info("Writing:" + f + "  length:" + bytes.length);
                Files.write((byte[])bytes, (File)f);
                return result;
            }
            byte[] existing = Files.toByteArray((File)f);
            if (Arrays.equals(bytes, existing)) {
                log.info("array already stored:" + f + "  length:" + existing.length);
                return result;
            }
            log.info(String.format("collision:%x", result));
            ++result;
        }
        throw new IOException("Exceeded maximum collisions for content ID:" + baseId);
    }

    protected CellArray readCellArray(File f) throws IOException {
        byte[] test = Files.toByteArray((File)f);
        return CellArrayProtocol.fromBytes(test);
    }
}

