/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.objects;

import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.fbx.SceneLoader;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.objects.FbxAnimCurve;
import com.jme3.scene.plugins.fbx.objects.FbxObject;
import java.util.Collection;

public class FbxAnimNode
extends FbxObject {
    public Vector3f value;
    public FbxAnimCurve xCurve;
    public FbxAnimCurve yCurve;
    public FbxAnimCurve zCurve;
    public long layerId;

    public FbxAnimNode(SceneLoader scene, FbxElement element) {
        super(scene, element);
        if (this.type.equals("")) {
            Double x = null;
            Double y = null;
            Double z = null;
            for (FbxElement e2 : element.getFbxProperties()) {
                String propName;
                switch (propName = (String)e2.properties.get(0)) {
                    case "d|X": {
                        x = (Double)e2.properties.get(4);
                        break;
                    }
                    case "d|Y": {
                        y = (Double)e2.properties.get(4);
                        break;
                    }
                    case "d|Z": {
                        z = (Double)e2.properties.get(4);
                    }
                }
            }
            if (x != null && y != null && z != null) {
                this.value = new Vector3f(x.floatValue(), y.floatValue(), z.floatValue());
            }
        }
    }

    @Override
    public void link(FbxObject otherObject, String propertyName) {
        if (otherObject instanceof FbxAnimCurve) {
            FbxAnimCurve curve = (FbxAnimCurve)otherObject;
            switch (propertyName) {
                case "d|X": {
                    this.xCurve = curve;
                    break;
                }
                case "d|Y": {
                    this.yCurve = curve;
                    break;
                }
                case "d|Z": {
                    this.zCurve = curve;
                }
            }
        }
    }

    @Override
    public void link(FbxObject otherObject) {
        this.layerId = otherObject.id;
    }

    public boolean haveAnyChannel() {
        return this.xCurve != null || this.yCurve != null || this.zCurve != null;
    }

    public void exportTimes(Collection<Long> stamps) {
        if (this.xCurve != null) {
            for (long t : this.xCurve.keyTimes) {
                stamps.add(t);
            }
        }
        if (this.yCurve != null) {
            for (long t : this.yCurve.keyTimes) {
                stamps.add(t);
            }
        }
        if (this.zCurve != null) {
            for (long t : this.zCurve.keyTimes) {
                stamps.add(t);
            }
        }
    }

    public Vector3f getValue(long time, Vector3f defaultValue) {
        float xValue = this.xCurve != null ? this.xCurve.getValue(time) : defaultValue.x;
        float yValue = this.yCurve != null ? this.yCurve.getValue(time) : defaultValue.y;
        float zValue = this.zCurve != null ? this.zCurve.getValue(time) : defaultValue.z;
        return new Vector3f(xValue, yValue, zValue);
    }
}

