/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mworld.World;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorldCellDataAdapter
implements CellData {
    static Logger log = LoggerFactory.getLogger(WorldCellDataAdapter.class);
    private World world;

    public WorldCellDataAdapter(World world) {
        this.world = world;
    }

    public final int getCell(int x, int y, int z) {
        return this.world.getWorldCell(new Vec3d((double)x, (double)y, (double)z));
    }

    public final int getCell(int x, int y, int z, int defaultValue) {
        if (y > this.world.getMaxY()) {
            return defaultValue;
        }
        return this.getCell(x, y, z);
    }

    public final int getCell(int x, int y, int z, Direction dir, int defaultValue) {
        Vec3i v = dir.getVec3i();
        return this.getCell(x + v.x, y + v.y, z + v.z, defaultValue);
    }

    public final void setCell(int x, int y, int z, int type) {
        this.world.setWorldCell(new Vec3d((double)x, (double)y, (double)z), type);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[world:" + this.world + "]";
    }
}

