/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mphys;

import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.mphys.AbstractShape;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapeFactoryRegistry<S extends AbstractShape>
implements ShapeFactory<S> {
    static Logger log = LoggerFactory.getLogger(ShapeFactoryRegistry.class);
    private Map<String, ShapeFactory<? extends S>> registry = new HashMap<String, ShapeFactory<? extends S>>();
    private ShapeFactory<? extends S> defaultFactory;

    public void setDefaultFactory(ShapeFactory<? extends S> factory) {
        this.defaultFactory = factory;
    }

    public ShapeFactory<? extends S> getDefaultFactory() {
        return this.defaultFactory;
    }

    public void registerFactory(String name, ShapeFactory<? extends S> factory) {
        this.registry.put(name, factory);
    }

    public ShapeFactory<? extends S> getFactory(String name) {
        ShapeFactory<? extends S> result = this.registry.get(name);
        if (result == null && log.isDebugEnabled()) {
            log.debug("Using default.  Missed:" + name + " in registry keys:" + this.registry.keySet());
        }
        return result == null ? this.defaultFactory : result;
    }

    @Override
    public S createShape(String name, double scale, Mass mass) {
        ShapeFactory<S> factory = this.getFactory(name);
        return factory == null ? null : (S)factory.createShape(name, scale, mass);
    }
}

