/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.io;

import com.google.common.base.Charsets;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellUtils;
import com.simsilica.mblock.FluidName;
import com.simsilica.mblock.FluidType;
import com.simsilica.mblock.FluidTypeIndex;
import com.simsilica.mblock.FluidUtils;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.io.BlockObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlocksFileFormat {
    static Logger log = LoggerFactory.getLogger(BlocksFileFormat.class);
    private static Pattern TRIPLE = Pattern.compile("%\\w+:\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)");
    private static Pattern VALUE = Pattern.compile("%\\w+:\\s*(\\w+)\\s*=\\s*(.+)");
    private static Pattern NUM_PAIR = Pattern.compile("(\\d+):(\\d+)");

    private BlocksFileFormat() {
    }

    public static CellArray loadCellArray(String resource) throws IOException {
        log.info("loadCellArray(" + resource + ")");
        InputStream in = BlocksFileFormat.class.getResourceAsStream(resource);
        if (in == null) {
            throw new IOException("Resource not found:" + resource);
        }
        return BlocksFileFormat.loadCellArray(in);
    }

    public static CellArray loadCellArray(InputStream rawIn) throws IOException {
        BlockObject blocks = BlocksFileFormat.readBlocks(rawIn, true);
        return blocks.cells;
    }

    public static void writeBlocks(BlockObject blocks, File f) throws IOException {
        try (FileOutputStream out = new FileOutputStream(f);){
            BlocksFileFormat.writeBlocks(blocks, out);
        }
    }

    public static void writeBlocks(BlockObject blocks, OutputStream rawOut) throws IOException {
        BlocksFileFormat.writeBlocks(rawOut, blocks.cells, blocks.fluids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeBlocks(OutputStream rawOut, CellArray cells, CellArray fluids) throws IOException {
        TreeMap<Integer, String> nameIndex = new TreeMap<Integer, String>();
        TreeMap<Integer, String> fluidNameIndex = new TreeMap<Integer, String>();
        OutputStreamWriter sOut = new OutputStreamWriter(rawOut, Charsets.UTF_8);
        try (PrintWriter out = new PrintWriter(sOut);){
            int x;
            int y;
            int type;
            int val;
            int sizeX = cells.getSizeX();
            int sizeY = cells.getSizeY();
            int sizeZ = cells.getSizeZ();
            int minX = sizeX;
            int minY = sizeY;
            int minZ = sizeZ;
            int maxX = 0;
            int maxY = 0;
            int maxZ = 0;
            int fminX = sizeX;
            int fminY = sizeY;
            int fminZ = sizeZ;
            int fmaxX = 0;
            int fmaxY = 0;
            int fmaxZ = 0;
            for (int x2 = 0; x2 < sizeX; ++x2) {
                for (int y2 = 0; y2 < sizeY; ++y2) {
                    for (int z = 0; z < sizeZ; ++z) {
                        val = cells.getCell(x2, y2, z);
                        type = MaskUtils.getType(val);
                        if (type != 0) {
                            minX = Math.min(minX, x2);
                            maxX = Math.max(maxX, x2);
                            minY = Math.min(minY, y2);
                            maxY = Math.max(maxY, y2);
                            minZ = Math.min(minZ, z);
                            maxZ = Math.max(maxZ, z);
                            BlockType bt = BlockTypeIndex.get(type);
                            nameIndex.put(type, bt.getName().toString());
                        }
                        if ((type = FluidUtils.getType(val = fluids.getCell(x2, y2, z))) == 0) continue;
                        fminX = Math.min(fminX, x2);
                        fmaxX = Math.max(fmaxX, x2);
                        fminY = Math.min(fminY, y2);
                        fmaxY = Math.max(fmaxY, y2);
                        fminZ = Math.min(fminZ, z);
                        fmaxZ = Math.max(fmaxZ, z);
                        FluidType ft = FluidTypeIndex.get(type);
                        fluidNameIndex.put(type, ft.getName().toString());
                    }
                }
            }
            out.println("%BlockEd version 1");
            out.println("%size: " + sizeX + ", " + sizeY + ", " + sizeZ);
            out.println("%order: y, z, x");
            out.println("%compression: none");
            for (Map.Entry e : nameIndex.entrySet()) {
                out.println("%type:" + e.getKey() + "=" + (String)e.getValue());
            }
            for (Map.Entry e : fluidNameIndex.entrySet()) {
                out.println("%fluidType:" + e.getKey() + "=" + (String)e.getValue());
            }
            out.println("%min: " + minX + ", " + minY + ", " + minZ);
            out.println("%max: " + maxX + ", " + maxY + ", " + maxZ);
            for (y = minY; y <= maxY; ++y) {
                out.println("%y:" + y);
                for (int z = minZ; z <= maxZ; ++z) {
                    for (x = minX; x <= maxX; ++x) {
                        val = cells.getCell(x, y, z);
                        type = MaskUtils.getType(val);
                        out.print(type);
                        if (x >= maxX) continue;
                        out.print(", ");
                    }
                    out.println();
                }
            }
            out.println("%fluidMin: " + fminX + ", " + fminY + ", " + fminZ);
            out.println("%fluidMax: " + fmaxX + ", " + fmaxY + ", " + fmaxZ);
            for (y = fminY; y <= fmaxY; ++y) {
                out.println("%yFluid:" + y);
                for (int z = fminZ; z <= fmaxZ; ++z) {
                    for (x = fminX; x <= fmaxX; ++x) {
                        val = fluids.getCell(x, y, z);
                        type = FluidUtils.getType(val);
                        int level = FluidUtils.getLevel(val);
                        out.print(type + ":" + level);
                        if (x >= fmaxX) continue;
                        out.print(", ");
                    }
                    out.println();
                }
            }
        }
    }

    public static BlockObject readBlocks(File f, boolean trim) throws IOException {
        try (FileInputStream in = new FileInputStream(f);){
            BlockObject blockObject = BlocksFileFormat.readBlocks(in, trim);
            return blockObject;
        }
    }

    public static BlockObject readBlocks(String resource, boolean trim) throws IOException {
        InputStream in = BlocksFileFormat.class.getResourceAsStream(resource);
        if (in == null) {
            throw new IOException("Resource not found:" + resource);
        }
        return BlocksFileFormat.readBlocks(in, trim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlockObject readBlocks(InputStream rawIn, boolean trim) throws IOException {
        InputStreamReader rIn = new InputStreamReader(rawIn, Charsets.UTF_8);
        try (BufferedReader in = new BufferedReader(rIn);){
            String line = null;
            CellArray cells = null;
            CellArray fluids = null;
            int sizeX = 0;
            int sizeY = 0;
            int sizeZ = 0;
            HashMap<Integer, String> typeIndex = new HashMap<Integer, String>();
            HashMap<Integer, Integer> remap = new HashMap<Integer, Integer>();
            HashMap<Integer, String> fTypeIndex = new HashMap<Integer, String>();
            HashMap<Integer, Integer> fRemap = new HashMap<Integer, Integer>();
            CellArray target = cells;
            boolean isFluid = false;
            int minX = 0;
            int minY = 0;
            int minZ = 0;
            int maxX = 0;
            int maxY = 0;
            int maxZ = 0;
            int bminX = 0;
            int bminY = 0;
            int bminZ = 0;
            int bmaxX = 0;
            int bmaxY = 0;
            int bmaxZ = 0;
            int fminX = 0;
            int fminY = 0;
            int fminZ = 0;
            int fmaxX = 0;
            int fmaxY = 0;
            int fmaxZ = 0;
            int y = 0;
            int z = 0;
            while ((line = in.readLine()) != null) {
                int[] sizes;
                int index;
                Serializable name;
                int type;
                String[] words;
                if ((line = line.trim()).startsWith("#") || line.startsWith("//")) continue;
                if (line.startsWith("%BlockEd version")) {
                    if (line.equals("%BlockEd version 1")) continue;
                    throw new IOException("Unsupported version:" + line);
                }
                if (line.startsWith("%order")) {
                    if (line.equals("%order: y, z, x")) continue;
                    throw new IOException("Unsupported order:" + line);
                }
                if (line.startsWith("%compression")) {
                    if (line.equals("%compression: none")) continue;
                    throw new IOException("Unsupported compression:" + line);
                }
                if (line.startsWith("%type:")) {
                    words = BlocksFileFormat.parseValue(line);
                    type = Integer.parseInt(words[0]);
                    typeIndex.put(type, words[1]);
                    name = BlockName.parse(words[1]);
                    log.debug("block name:" + name);
                    index = BlockTypeIndex.findType(name);
                    log.debug("index:" + index);
                    if (type == index) continue;
                    remap.put(type, index);
                    continue;
                }
                if (line.startsWith("%fluidType:")) {
                    words = BlocksFileFormat.parseValue(line);
                    type = Integer.parseInt(words[0]);
                    fTypeIndex.put(type, words[1]);
                    name = new FluidName(words[1]);
                    log.debug("fluid name:" + name);
                    index = FluidTypeIndex.findType((FluidName)name);
                    log.debug("index:" + index);
                    if (type == index) continue;
                    fRemap.put(type, index);
                    continue;
                }
                if (line.startsWith("%size")) {
                    sizes = BlocksFileFormat.parseTriple(line);
                    if (sizes == null) {
                        throw new IOException("Bad format in size directive:" + line);
                    }
                    sizeX = sizes[0];
                    sizeY = sizes[1];
                    sizeZ = sizes[2];
                    cells = new CellArray(sizeX, sizeY, sizeZ);
                    continue;
                }
                if (line.startsWith("%min:")) {
                    sizes = BlocksFileFormat.parseTriple(line);
                    if (sizes == null) {
                        throw new IOException("Bad format in min directive:" + line);
                    }
                    bminX = sizes[0];
                    bminY = sizes[1];
                    bminZ = sizes[2];
                    y = minY;
                    z = minZ;
                    continue;
                }
                if (line.startsWith("%max:")) {
                    sizes = BlocksFileFormat.parseTriple(line);
                    if (sizes == null) {
                        throw new IOException("Bad format in max directive:" + line);
                    }
                    bmaxX = sizes[0];
                    bmaxY = sizes[1];
                    bmaxZ = sizes[2];
                    continue;
                }
                if (line.startsWith("%fluidMin:")) {
                    sizes = BlocksFileFormat.parseTriple(line);
                    if (sizes == null) {
                        throw new IOException("Bad format in min directive:" + line);
                    }
                    fminX = sizes[0];
                    fminY = sizes[1];
                    fminZ = sizes[2];
                    y = minY;
                    z = minZ;
                    continue;
                }
                if (line.startsWith("%fluidMax:")) {
                    sizes = BlocksFileFormat.parseTriple(line);
                    if (sizes == null) {
                        throw new IOException("Bad format in max directive:" + line);
                    }
                    fmaxX = sizes[0];
                    fmaxY = sizes[1];
                    fmaxZ = sizes[2];
                    continue;
                }
                if (line.startsWith("%y:")) {
                    y = Integer.parseInt(line.substring("%y:".length()));
                    minX = bminX;
                    maxX = bmaxX;
                    minY = bminY;
                    maxY = bmaxY;
                    minZ = bminZ;
                    maxZ = bmaxZ;
                    z = minZ;
                    target = cells;
                    isFluid = false;
                    continue;
                }
                if (line.startsWith("%yFluid:")) {
                    if (fluids == null) {
                        fluids = new CellArray(sizeX, sizeY, sizeZ);
                    }
                    y = Integer.parseInt(line.substring("%yFluid:".length()));
                    minX = fminX;
                    maxX = fmaxX;
                    minY = fminY;
                    maxY = fmaxY;
                    minZ = fminZ;
                    maxZ = fmaxZ;
                    z = minZ;
                    target = fluids;
                    isFluid = true;
                    continue;
                }
                if (line.startsWith("%")) {
                    throw new IOException("Unhandled directive:" + line);
                }
                String[] tokens = line.split(",\\s*");
                for (int i = 0; i < tokens.length; ++i) {
                    Integer override;
                    if (isFluid) {
                        int[] values = BlocksFileFormat.parsePair(tokens[i]);
                        override = (Integer)fRemap.get(values[0]);
                        if (override != null) {
                            values[0] = override;
                        }
                        int value = FluidUtils.setLevel(values[0], values[1]);
                        target.setCell(fminX + i, y, z, value);
                        continue;
                    }
                    int value = Integer.parseInt(tokens[i]);
                    override = (Integer)remap.get(value);
                    if (override != null) {
                        value = override;
                    }
                    target.setCell(minX + i, y, z, value);
                }
                ++z;
            }
            log.debug("remap:" + remap);
            log.debug("fremap:" + fRemap);
            MaskUtils.calculateSideMasks(cells);
            if (fluids != null) {
                FluidUtils.calculateSideMasks(fluids, cells);
            }
            if (trim) {
                if (fluids != null) {
                    minX = Math.min(bminX, fminX);
                    minY = Math.min(bminY, fminY);
                    minZ = Math.min(bminZ, fminZ);
                    maxX = Math.max(bmaxX, fmaxX);
                    maxY = Math.max(bmaxY, fmaxY);
                    maxZ = Math.max(bmaxZ, fmaxZ);
                }
                int xs = maxX - minX + 1;
                int ys = maxY - minY + 1;
                int zs = maxZ - minZ + 1;
                cells = CellUtils.trim(cells, minX, minY, minZ, xs, ys, zs);
                if (fluids != null) {
                    fluids = CellUtils.trim(fluids, minX, minY, minZ, xs, ys, zs);
                }
            }
            BlockObject blockObject = new BlockObject(cells, fluids);
            return blockObject;
        }
    }

    private static int[] parseTriple(String s) {
        Matcher m = TRIPLE.matcher(s);
        if (!m.matches()) {
            return null;
        }
        int[] result = new int[3];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Integer.parseInt(m.group(i + 1));
        }
        return result;
    }

    private static String[] parseValue(String s) {
        Matcher m = VALUE.matcher(s);
        if (!m.matches()) {
            return null;
        }
        String[] result = new String[2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = m.group(i + 1);
        }
        return result;
    }

    private static int[] parsePair(String s) {
        Matcher m = NUM_PAIR.matcher(s);
        if (!m.matches()) {
            return null;
        }
        int[] result = new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2))};
        return result;
    }
}

