/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.common;

import com.simsilica.es.EntityComponent;
import com.simsilica.es.PersistentComponent;

public class Decay
implements EntityComponent,
PersistentComponent {
    private long startTime;
    private long endTime;

    public Decay() {
    }

    public Decay(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Decay(long endTime) {
        this.startTime = endTime;
        this.endTime = endTime;
    }

    public static Decay duration(long startTime, long duration) {
        return new Decay(startTime, startTime + duration);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getTimeRemaining(long time) {
        return Math.max(0L, this.endTime - time);
    }

    public boolean isDead(long time) {
        return time >= this.endTime;
    }

    public double getPercentRemaining(long time) {
        if (time >= this.endTime) {
            return 0.0;
        }
        if (this.startTime == this.endTime) {
            return 1.0;
        }
        long remain = this.endTime - time;
        double total = this.endTime - this.startTime;
        return (double)remain / total;
    }

    public String toString() {
        return "Decay[startTime=" + this.startTime + ", endTime=" + this.endTime + "]";
    }
}

