/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.state;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.renderer.Camera;

public class CameraState
extends BaseAppState {
    private Camera cam;
    private float fieldOfView;
    private float near;
    private float far;

    public CameraState() {
        this(null, 45.0f, 0.1f, 1000.0f);
    }

    public CameraState(float fov, float near, float far) {
        this(null, fov, near, far);
    }

    public CameraState(Camera cam, float fov, float near, float far) {
        this.cam = cam;
        this.fieldOfView = fov;
        this.near = near;
        this.far = far;
    }

    public void setCamera(Camera cam) {
        if (this.cam == cam) {
            return;
        }
        this.cam = cam;
        this.resetCamera();
    }

    public Camera getCamera() {
        if (this.cam != null) {
            return this.cam;
        }
        if (this.getApplication() != null) {
            return this.getApplication().getCamera();
        }
        return null;
    }

    public void setFieldOfView(float f) {
        if (this.fieldOfView == f) {
            return;
        }
        this.fieldOfView = f;
        this.resetCamera();
    }

    public float getFieldOfView() {
        return this.fieldOfView;
    }

    public void setNear(float f) {
        if (this.near == f) {
            return;
        }
        this.near = f;
        this.resetCamera();
    }

    public float getNear() {
        return this.near;
    }

    public void setFar(float f) {
        if (this.far == f) {
            return;
        }
        this.far = f;
        this.resetCamera();
    }

    public float getFar() {
        return this.far;
    }

    protected void initialize(Application app) {
    }

    protected void resetCamera() {
        if (this.isEnabled()) {
            Camera camera = this.getCamera();
            float aspect = (float)camera.getWidth() / (float)camera.getHeight();
            camera.setFrustumPerspective(this.fieldOfView, aspect, this.near, this.far);
        }
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.resetCamera();
    }

    protected void onDisable() {
    }
}

