/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import mythruna.sim.ai.Brain;
import mythruna.sim.ai.SignalGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalGenerators {
    static Logger log = LoggerFactory.getLogger(SignalGenerators.class);

    public static IntervalGenerator interval(double frequency, SignalGenerator delegate) {
        return SignalGenerators.interval(Math.random() * frequency, frequency, delegate);
    }

    public static IntervalGenerator interval(double startOffset, double frequency, SignalGenerator delegate) {
        return new IntervalGenerator(startOffset, frequency, delegate);
    }

    public static class IntervalGenerator
    implements SignalGenerator {
        private double startOffset;
        private double frequency;
        private SignalGenerator delegate;
        private double timeout;

        public IntervalGenerator(double startOffset, double frequency, SignalGenerator delegate) {
            this.timeout = startOffset;
            this.frequency = frequency;
            this.delegate = delegate;
        }

        public double getFrequency() {
            return this.frequency;
        }

        @Override
        public void generateSignals(Brain brain, long frameTime, double step) {
            this.timeout -= step;
            if (this.timeout <= 0.0) {
                this.timeout = this.frequency;
                this.delegate.generateSignals(brain, frameTime, this.frequency);
            }
        }
    }
}

