/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.fractal.AbstractSampler;
import com.simsilica.fractal.FractalUtils;
import com.simsilica.fractal.Sampler;
import mythruna.world.BioInfo;
import mythruna.world.WorldFractal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorldFractal
implements WorldFractal {
    static Logger log = LoggerFactory.getLogger(DefaultWorldFractal.class);
    private static final double INV_SQRT2 = 1.0 / Math.sqrt(2.0);
    private Sampler estimatedElevation;
    private Sampler elevation;
    private Sampler waterLevel;
    private Sampler temperature;
    private Sampler weather;
    private Sampler soilQuality;
    private Sampler vegetation;
    private static final double xOffset = 1000000.0;
    private static final double zOffset = 1000000.0;
    protected static double rescale = 1.0;
    int seaLevel = 128;
    private int treeLine = 490;
    private int deepWater = -100;

    public DefaultWorldFractal(Sampler estimatedElevation, Sampler elevation, Sampler waterLevel, Sampler temperature, Sampler weather, Sampler soilQuality, Sampler vegetation) {
        this.estimatedElevation = estimatedElevation;
        this.elevation = elevation;
        this.waterLevel = waterLevel;
        this.temperature = temperature;
        this.weather = weather;
        this.soilQuality = soilQuality;
        this.vegetation = vegetation;
    }

    @Override
    public long getFractalHash() {
        String s = this.elevation + ", " + this.waterLevel + ", " + this.temperature + ", " + this.weather + ", " + this.soilQuality + ", " + this.vegetation;
        log.info("Fractal hash basis:" + s);
        return s.hashCode();
    }

    private double xRescale(double x) {
        return x + 1000000.0;
    }

    private double zRescale(double z) {
        return z + 1000000.0;
    }

    private double yUnscale(double y) {
        return y;
    }

    private double yRescale(double y) {
        return y;
    }

    @Override
    public double getEstimatedElevation(double x, double z) {
        return this.yUnscale(this.estimatedElevation.getSample(this.xRescale(x), 0.0, this.zRescale(z)));
    }

    @Override
    public double getElevation(double x, double z) {
        return this.yUnscale(this.elevation.getSample(this.xRescale(x), 0.0, this.zRescale(z)));
    }

    @Override
    public double getWaterLevel(double x, double y, double z) {
        return this.waterLevel.getSample(this.xRescale(x), this.yRescale(y), this.zRescale(z));
    }

    @Override
    public double getTemperature(double x, double y, double z) {
        return this.temperature.getSample(this.xRescale(x), this.yRescale(y), this.zRescale(z));
    }

    @Override
    public double getAdjustedTemperature(double x, double y, double z) {
        double temperature = this.getTemperature(x, y, z);
        return this.getAdjustedTemperature(x, y, z, temperature);
    }

    protected double getAdjustedTemperature(double x, double y, double z, double temperature) {
        double baselineHeight;
        int seaLevel = 128;
        int treeLine = 490;
        double height = Math.abs(y - (double)seaLevel) / (double)treeLine;
        if (height > (baselineHeight = 0.2)) {
            double heightEffect = (height - baselineHeight) / (1.0 - baselineHeight);
            double temperatureAdjust = heightEffect * 0.4;
            temperature -= temperatureAdjust;
        }
        return temperature;
    }

    @Override
    public double getWeather(double x, double y, double z) {
        return this.weather.getSample(this.xRescale(x), this.yRescale(y), this.zRescale(z));
    }

    @Override
    public double getAdjustedWeather(double x, double y, double z, double temperature) {
        double baseWeather = this.getWeather(x, y, z);
        return this.getAdjustedWeather(x, y, z, temperature, baseWeather);
    }

    protected double getAdjustedWeather(double x, double y, double z, double temperature, double baseWeather) {
        double effectiveWeather = baseWeather;
        if (temperature > 0.857) {
            double weatherAdjust = (temperature - 0.857) / 0.14300000000000002;
            weatherAdjust = 1.0 - weatherAdjust;
            effectiveWeather *= weatherAdjust;
        }
        return effectiveWeather;
    }

    @Override
    public double getSoilQuality(double x, double y, double z) {
        return this.soilQuality.getSample(this.xRescale(x), this.yRescale(y), this.zRescale(z));
    }

    @Override
    public double getClimate(double x, double y, double z, double t, double w) {
        double lowCut = 0.143;
        double midCut1 = 0.286;
        double midCut2 = 0.786;
        double hiCut = 0.923;
        double tempFactor = t < lowCut || t >= hiCut ? 0.0 : (t < midCut1 ? FractalUtils.smoothStep((double)lowCut, (double)midCut1, (double)t) : (t > midCut2 ? FractalUtils.smoothStep((double)hiCut, (double)midCut2, (double)t) : 1.0));
        double wetnessFactor = w;
        return tempFactor * wetnessFactor;
    }

    @Override
    public double getVegetationLevel(double x, double y, double z, double climate) {
        double v = this.vegetation.getSample(this.xRescale(x), this.yRescale(y), this.zRescale(z));
        v = FractalUtils.normalize((double)v, (double)0.0, (double)INV_SQRT2);
        double minLevel = climate * 0.5;
        double maxLevel = 1.5;
        v = minLevel + v * (maxLevel - minLevel);
        return v;
    }

    @Override
    public BioInfo getBioInfo(double x, double y, double z, BioInfo target) {
        if (target == null) {
            target = new BioInfo();
        }
        target.baseTemperature = this.getTemperature(x, y, z);
        target.temperature = this.getAdjustedTemperature(x, y, z, target.baseTemperature);
        target.basePrecipitation = this.getWeather(x, y, z);
        target.precipitation = this.getAdjustedWeather(x, y, z, target.baseTemperature, target.basePrecipitation);
        target.soilQuality = this.getSoilQuality(x, y, z);
        target.climate = this.getClimate(x, y, z, target.temperature, target.precipitation);
        target.baseVegetationLevel = this.getVegetationLevel(x, y, z, target.climate);
        target.vegetationLevel = target.climate * (target.baseVegetationLevel + (target.soilQuality - 0.5));
        return target;
    }

    public Sampler getTerrainSampler() {
        return new AbstractSampler(-128.0, 640.0){

            public double getSample(double x, double y, double z) {
                return DefaultWorldFractal.this.getElevation(x, z) - 128.0;
            }
        };
    }

    public Sampler getTemperatureSampler() {
        return new AbstractSampler(0.0, 1.0){

            public double getSample(double x, double y, double z) {
                return DefaultWorldFractal.this.getTemperature(x, y, z);
            }
        };
    }

    public Sampler getWeatherSampler() {
        return new AbstractSampler(0.0, 1.0){

            public double getSample(double x, double y, double z) {
                return DefaultWorldFractal.this.getWeather(x, y, z);
            }
        };
    }

    public Sampler getVegSampler() {
        return new AbstractSampler(0.0, 1.0){

            public double getSample(double x, double y, double z) {
                if (y > (double)DefaultWorldFractal.this.treeLine) {
                    return 0.0;
                }
                if (y < (double)DefaultWorldFractal.this.deepWater) {
                    return 0.0;
                }
                double t = DefaultWorldFractal.this.getAdjustedTemperature(x, y, z);
                double w = DefaultWorldFractal.this.getAdjustedWeather(x, y, z, t);
                double c = DefaultWorldFractal.this.getClimate(x, y, z, t, w);
                double q = DefaultWorldFractal.this.getSoilQuality(x, y, z);
                double result = DefaultWorldFractal.this.getVegetationLevel(x, y, z, c);
                result = c * (result + (q - 0.5));
                if (y < 0.0) {
                    result *= 0.5;
                }
                result = FractalUtils.clamp((double)result, (double)0.0, (double)1.0);
                return result;
            }
        };
    }
}

