/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.sound;

import com.simsilica.lemur.Button;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.GuiGlobals;
import mythruna.client.sound.Sound;
import mythruna.client.sound.SoundState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundCommand
implements Command<Button> {
    static Logger log = LoggerFactory.getLogger(SoundCommand.class);
    private String soundName;
    private float volume;

    public SoundCommand(String soundName) {
        this(soundName, 1.0f);
    }

    public SoundCommand(String soundName, float volume) {
        this.soundName = soundName;
        this.volume = volume;
    }

    public String getSoundName() {
        return this.soundName;
    }

    public float getVolume() {
        return this.volume;
    }

    public void execute(Button source) {
        SoundState sounds = (SoundState)GuiGlobals.getInstance().getAnimationState().getState(SoundState.class);
        Sound sound = sounds.playEffect(this.soundName);
        sound.setVolume(this.volume);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[soundName:" + this.soundName + ", volume:" + this.volume + "]";
    }
}

