/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.map;

import com.jme3.math.Vector2f;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityCriteria;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.VersionedList;
import java.util.Arrays;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mythruna.client.BackgroundRetrieverState;
import mythruna.client.ui.map.AtlasIconComponent;
import mythruna.es.CustomMapMarker;
import mythruna.es.ObjectName;
import mythruna.es.OwnedBy;
import mythruna.shape.IconName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconSet {
    static Logger log = LoggerFactory.getLogger(IconSet.class);
    private EntityData ed;
    private BackgroundRetrieverState retriever;
    private EntityId worldEntity;
    private IconContainer icons;
    private boolean sortInvalid;
    private VersionedList<Icon> iconList = new VersionedList();
    private static final Pattern PREFIX_PATTERN = Pattern.compile("^\\w+\\)\\s*(.*)");

    public IconSet(EntityData ed, EntityId worldEntity, BackgroundRetrieverState retriever) {
        this.ed = ed;
        this.retriever = retriever;
        this.worldEntity = worldEntity;
        this.icons = new IconContainer(ed, worldEntity);
    }

    public VersionedList<Icon> getIcons() {
        return this.iconList;
    }

    public void start() {
        this.icons.start();
    }

    public boolean update() {
        if (this.icons.update()) {
            this.sortInvalid = true;
        }
        if (this.sortInvalid) {
            this.resort();
            return true;
        }
        return false;
    }

    public void stop() {
        this.icons.stop();
    }

    protected void resort() {
        log.info("resorting");
        this.sortInvalid = false;
        TreeSet<Icon> sorted = new TreeSet<Icon>(Arrays.asList(this.icons.getArray()));
        this.iconList.clear();
        for (Icon icon : sorted) {
            this.iconList.add((Object)icon);
        }
    }

    protected static String removePrefix(String name) {
        if (name == null) {
            return null;
        }
        Matcher m = PREFIX_PATTERN.matcher(name);
        if (m.matches()) {
            return m.group(1);
        }
        return name;
    }

    private class IconContainer
    extends EntityContainer<Icon> {
        protected IconContainer(EntityData ed, EntityId worldEntity) {
            super(ed, new EntityCriteria().add(new ComponentFilter[]{OwnedBy.filter((EntityId)worldEntity)}).add(new Class[]{ObjectName.class}).add(new Class[]{CustomMapMarker.class}));
        }

        protected Icon[] getArray() {
            return (Icon[])super.getArray();
        }

        protected Icon addObject(Entity entity) {
            log.info("addObject(" + entity + ")");
            Icon result = new Icon(entity);
            this.updateObject(result, entity);
            return result;
        }

        protected void updateObject(Icon object, Entity entity) {
            log.info("updateObject(" + entity + ")");
            object.update();
        }

        protected void removeObject(Icon object, Entity entity) {
            log.info("removeObject(" + entity + ")");
            object.release();
        }
    }

    public class Icon
    implements Comparable<Icon> {
        private Entity entity;
        private CustomMapMarker template;
        private IconName iconName;
        private String name;
        private Label nameLabel;
        private AtlasIconComponent iconComponent;

        protected Icon(Entity entity) {
            this.entity = entity;
            this.name = "";
            this.nameLabel = new Label(this.name);
            this.iconComponent = new AtlasIconComponent(new IconName("/Interface/flag-icon.png", null, null));
            this.iconComponent.setIconScale(1.0f);
            this.iconComponent.setMargin(0.0f, 0.0f);
            this.iconComponent.setIconSize(new Vector2f(32.0f, 32.0f));
            this.nameLabel.setIcon((GuiComponent)this.iconComponent);
        }

        @Override
        public int compareTo(Icon other) {
            return this.name.compareTo(other.name);
        }

        public Label getName() {
            return this.nameLabel;
        }

        public int getIconId() {
            return ((CustomMapMarker)this.entity.get(CustomMapMarker.class)).getIconId();
        }

        public AtlasIconComponent getComponent() {
            return this.iconComponent;
        }

        protected void setName(String name) {
            if (Objects.equals(name, this.name)) {
                return;
            }
            this.name = name;
            this.nameLabel.setText(IconSet.removePrefix(name));
            IconSet.this.sortInvalid = true;
        }

        protected void setIconName(String name) {
            this.iconName = IconName.parse((String)name);
            this.iconComponent.setImageTexture(GuiGlobals.getInstance().loadTexture(this.iconName.getImageName(), false, false));
            this.iconComponent.setCell(this.iconName.getX(), this.iconName.getY());
            log.info("3) effective icon size:" + this.iconComponent.getEffectiveIconSize());
        }

        protected void update() {
            ObjectName on = (ObjectName)this.entity.get(ObjectName.class);
            IconSet.this.retriever.getString(on.getNameId(), this::setName);
            this.template = (CustomMapMarker)this.entity.get(CustomMapMarker.class);
            IconSet.this.retriever.getString(this.template.getIconId(), this::setIconName);
        }

        protected void release() {
        }
    }
}

