#import "Common/ShaderLib/GLSLCompat.glsllib"
#import "Common/ShaderLib/Skinning.glsllib"
#import "Common/ShaderLib/Instancing.glsllib"
#import "Common/ShaderLib/MorphAnim.glsllib"

attribute vec3 inPosition;

#if defined(HAS_NOISE_MAP) && !defined(SEPARATE_TEXCOORD)
    #define NEED_TEXCOORD1
#endif

#ifdef HAS_NOISE_MAP
    uniform sampler2D m_NoiseMap;
#endif

attribute vec2 inTexCoord;
attribute vec2 inTexCoord2;
attribute vec4 inColor;

varying vec2 texCoord1;
varying vec2 texCoord2;
varying vec3 vLocalOrigin;

varying vec4 vertColor;
#ifdef HAS_POINTSIZE
    uniform float m_PointSize;
#endif

void main(){
    #ifdef NEED_TEXCOORD1
        texCoord1 = inTexCoord;
    #endif

    #ifdef SEPARATE_TEXCOORD
        texCoord2 = inTexCoord2;
    #endif

    #ifdef HAS_VERTEXCOLOR
        vertColor = inColor;
    #endif

    #ifdef HAS_POINTSIZE
        gl_PointSize = m_PointSize;
    #endif

    #ifdef HAS_NOISE_MAP
        //vLocalOrigin = TransformWorld(vec4(0.0)).xyz;
        //vLocalOrigin = TransformWorld(vec4(inPosition, 1.0)).xyz;
        vLocalOrigin = TransformWorld(vec4(0.0, 0.0, 0.0, 1.0)).xyz;
        //vec2 uv = mod(localWorldOrigin.xz, 32.0) / 32.0;
        //timeOffset = texture2D(m_NoiseMap, uv).x * 60.0;
    #else
        vLocalOrigin = vec3(0.0);
    #endif

    vec4 modelSpacePos = vec4(inPosition, 1.0);

    #ifdef NUM_MORPH_TARGETS
        Morph_Compute(modelSpacePos);
    #endif

    #ifdef NUM_BONES
        Skinning_Compute(modelSpacePos);
    #endif

    gl_Position = TransformWorldViewProjection(modelSpacePos);
}