/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.path;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.morph.Morphology;
import com.simsilica.mworld.tile.morph.MorphologyLayer;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import mythruna.world.path.RoadSection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoadFileTileFunction
implements TileFunction {
    static Logger log = LoggerFactory.getLogger(RoadFileTileFunction.class);
    private List<RoadSection> sections;

    public RoadFileTileFunction(File file) {
        try {
            String json = Files.toString((File)file, (Charset)Charsets.UTF_8);
            GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
            Gson gson = gsonBuilder.create();
            TypeToken<List<RoadSection>> collectionType = new TypeToken<List<RoadSection>>(this){};
            this.sections = (List)gson.fromJson(json, collectionType.getType());
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading file:" + file, e);
        }
    }

    protected boolean intersects(Vec3i tileOrigin, RoadSection section) {
        Vec3i min = section.getStart().clone().minLocal(section.getEnd());
        Vec3i max = section.getStart().clone().maxLocal(section.getEnd());
        int extend = (int)Math.ceil((double)section.getWidth() * 0.5);
        min.subtractLocal(extend, 0, extend);
        max.addLocal(extend, 0, extend);
        if (max.x < tileOrigin.x || max.z < tileOrigin.z) {
            return false;
        }
        return min.x < tileOrigin.x + 1024 && min.z < tileOrigin.z + 1024;
    }

    public void accept(Tile tile) {
        MorphologyLayer morph = (MorphologyLayer)tile.get(MorphologyLayer.class);
        if (morph == null) {
            morph = new MorphologyLayer(tile.getTileId(), new DataVersion(0L, -1L));
            tile.put(MorphologyLayer.class, (Object)morph);
        } else if (morph.getVersion().getLoadVersion() >= 0L) {
            return;
        }
        Vec3i origin = tile.getTileId().getWorld(null);
        for (RoadSection section : this.sections) {
            if (!this.intersects(origin, section)) continue;
            morph.addMorphology((Morphology)section);
        }
    }
}

