/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.RigidBody;
import com.simsilica.mphys.StaticBody;

public class QueryFilter<K, S extends AbstractShape> {
    public static final int TYPE_WORLD = 1;
    public static final int TYPE_STATIC = 2;
    public static final int TYPE_INACTIVE = 4;
    public static final int TYPE_ACTIVE = 8;
    public static final int TYPE_ALL = 255;
    private int flags;
    private Predicate<? super RigidBody<K, S>> rigidBodyFilter;
    private Predicate<? super StaticBody<K, S>> staticBodyFilter;

    public QueryFilter(int flags) {
        this(flags, Predicates.alwaysTrue(), Predicates.alwaysTrue());
    }

    public QueryFilter(int flags, Predicate<? super RigidBody<K, S>> rigidBodyFilter, Predicate<? super StaticBody<K, S>> staticBodyFilter) {
        this.flags = flags;
        this.rigidBodyFilter = rigidBodyFilter;
        this.staticBodyFilter = staticBodyFilter;
    }

    public Predicate<? super RigidBody<K, S>> getRigidBodyFilter() {
        return this.rigidBodyFilter;
    }

    public Predicate<? super StaticBody<K, S>> getStaticBodyFilter() {
        return this.staticBodyFilter;
    }

    public boolean includeWorld() {
        return (this.flags & 1) != 0;
    }

    public boolean includeStatic() {
        return (this.flags & 2) != 0;
    }

    public boolean includeInactive() {
        return (this.flags & 4) != 0;
    }

    public boolean includeActive() {
        return (this.flags & 8) != 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + Integer.toBinaryString(this.flags) + "]";
    }
}

