/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fractal;

import com.google.common.base.MoreObjects;
import com.simsilica.fractal.AbstractCellularSampler;
import com.simsilica.fractal.CellularNoise;
import com.simsilica.fractal.Sampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellularFilter
extends AbstractCellularSampler {
    static Logger log = LoggerFactory.getLogger(CellularNoise.class);
    private Sampler delegate;

    public CellularFilter(Sampler delegate) {
        this(0L, delegate);
    }

    public CellularFilter(long seed, Sampler delegate) {
        super(seed, delegate.getRange());
        this.delegate = delegate;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("seed", this.getSeed()).add("delegate", (Object)this.delegate).toString();
    }

    @Override
    public double getSample(double x, double y, double z) {
        double xf = x % 1.0;
        double zf = z % 1.0;
        double xCell = Math.floor(x);
        double zCell = Math.floor(z);
        double min = Double.POSITIVE_INFINITY;
        double xBest = 0.0;
        double zBest = 0.0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                double zn;
                double zd;
                double xn = this.getRandomX(xCell + (double)i, zCell + (double)j) + (double)i;
                double xd = xf - xn;
                double d = xd * xd + (zd = zf - (zn = this.getRandomZ(xCell + (double)i, zCell + (double)j) + (double)j)) * zd;
                if (!(d < min)) continue;
                min = d;
                xBest = xn + xCell;
                zBest = zn + zCell;
            }
        }
        return this.delegate.getSample(xBest, 0.0, zBest);
    }
}

