/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.map;

import com.jme3.scene.Spatial;
import com.simsilica.es.EntityId;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Vec3d;
import mythruna.client.ui.map.DefaultMapToolLayer;
import mythruna.client.ui.map.MapToolState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectToolLayer
extends DefaultMapToolLayer {
    static Logger log = LoggerFactory.getLogger(SelectToolLayer.class);
    private MapToolState parent;
    private Label helpText;

    public SelectToolLayer(MapToolState parent) {
        this.parent = parent;
        this.helpText = new Label("Select tool tips:\nLeft Mouse: Edit\nSelect specific tool\nfor more options.", new ElementId("help.tips.label"));
    }

    @Override
    protected void onActivate() {
        this.parent.setLayerEditor((Panel)this.helpText);
    }

    @Override
    protected void onDeactivate() {
        this.parent.setLayerEditor(null);
    }

    @Override
    public void click(int button, Vec3d world, Spatial collision) {
        EntityId id = this.parent.getEntityIdForCollision(collision);
        if (button == 0) {
            log.info("left click:" + id);
        } else {
            log.info("right click:" + id);
        }
    }
}

