/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.event;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.event.PickEventSession;
import com.simsilica.lemur.event.PickState;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePickState
extends BaseAppState
implements PickState {
    static Logger log = LoggerFactory.getLogger(BasePickState.class);
    private boolean includeDefaultNodes = true;
    private long sampleFrequency = 16666666L;
    private long lastSample = 0L;
    private PickEventSession session = new PickEventSession();
    private Map<Object, Integer> owners = new HashMap<Object, Integer>();
    private int totalRequests = 0;

    protected BasePickState() {
    }

    protected final PickEventSession getSession() {
        return this.session;
    }

    @Override
    public void requestEnabled(Object owner) {
        Integer existing;
        if (log.isTraceEnabled()) {
            log.trace("requestEnabled(" + owner + ")");
        }
        if ((existing = this.owners.get(owner)) == null) {
            this.owners.put(owner, 1);
        } else {
            this.owners.put(owner, existing + 1);
        }
        ++this.totalRequests;
        if (log.isTraceEnabled()) {
            log.trace("request: Total enabled requests:" + this.totalRequests);
        }
        this.setEnabled(true);
    }

    @Override
    public boolean releaseEnabled(Object owner) {
        Integer existing;
        if (log.isTraceEnabled()) {
            log.trace("releaseEnabled(" + owner + ")");
        }
        if ((existing = this.owners.get(owner)) == null || existing == 0) {
            throw new IllegalArgumentException("Invalid owner, no requests pending");
        }
        if (existing == 1) {
            this.owners.remove(owner);
        } else {
            this.owners.put(owner, existing - 1);
        }
        --this.totalRequests;
        if (log.isTraceEnabled()) {
            log.trace("release: Total enabled requests:" + this.totalRequests);
        }
        if (this.totalRequests < 0) {
            log.error("Received more releases than requests, totalRequests:" + this.totalRequests + " at release of owner:" + owner);
        }
        this.setEnabled(this.totalRequests > 0);
        return this.isEnabled();
    }

    @Override
    public boolean hasRequestedEnabled(Object owner) {
        Integer existing = this.owners.get(owner);
        return existing != null && existing > 0;
    }

    @Override
    public boolean resetEnabled() {
        if (log.isTraceEnabled()) {
            log.trace("reset: Total enabled requests:" + this.totalRequests);
        }
        this.setEnabled(this.totalRequests > 0);
        return this.isEnabled();
    }

    @Override
    public void setIncludeDefaultCollisionRoots(boolean b) {
        this.includeDefaultNodes = b;
        if (this.isInitialized()) {
            if (b) {
                this.addCollisionRoot(this.getApplication().getGuiViewPort(), "gui");
                this.addCollisionRoot(this.getApplication().getViewPort(), "scene");
            } else {
                this.removeCollisionRoot(this.getApplication().getGuiViewPort());
                this.removeCollisionRoot(this.getApplication().getViewPort());
            }
        }
    }

    @Override
    public boolean getIncludeDefaultCollisionRoots() {
        return this.includeDefaultNodes;
    }

    @Deprecated
    public ViewPort findViewPort(Spatial s) {
        return this.session.findViewPort(s);
    }

    @Override
    public void addCollisionRoot(ViewPort viewPort) {
        this.session.addCollisionRoot(viewPort);
    }

    @Override
    public void addCollisionRoot(ViewPort viewPort, String layer) {
        this.session.addCollisionRoot(viewPort, layer);
    }

    @Override
    public void addCollisionRoot(Spatial root, ViewPort viewPort) {
        this.session.addCollisionRoot(root, viewPort);
    }

    @Override
    public void addCollisionRoot(Spatial root, ViewPort viewPort, String layer) {
        this.session.addCollisionRoot(root, viewPort, layer);
    }

    @Override
    public void removeCollisionRoot(ViewPort viewPort) {
        this.session.removeCollisionRoot(viewPort);
    }

    @Override
    public void removeCollisionRoot(Spatial root) {
        this.session.removeCollisionRoot(root);
    }

    @Override
    public void setPickLayerOrder(String ... layers) {
        this.session.setPickLayerOrder(layers);
    }

    @Override
    public String[] getPickLayerOrder() {
        return this.session.getPickLayerOrder();
    }

    protected void initialize(Application app) {
        if (this.includeDefaultNodes) {
            this.addCollisionRoot(this.getApplication().getGuiViewPort(), "gui");
            this.addCollisionRoot(this.getApplication().getViewPort(), "scene");
        }
    }

    protected void cleanup(Application app) {
        if (this.includeDefaultNodes) {
            this.removeCollisionRoot(app.getGuiViewPort());
            this.removeCollisionRoot(app.getViewPort());
        }
    }

    protected void onEnable() {
        this.getApplication().getInputManager().setCursorVisible(true);
    }

    protected void onDisable() {
        this.getApplication().getInputManager().setCursorVisible(false);
    }

    public void update(float tpf) {
        super.update(tpf);
        long time = System.nanoTime();
        if (time - this.lastSample < this.sampleFrequency) {
            return;
        }
        this.lastSample = time;
        this.dispatchMotion();
    }

    protected abstract void dispatchMotion();
}

