/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.event;

import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.simsilica.lemur.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MouseEventControl
extends AbstractControl {
    private List<MouseListener> listeners = new CopyOnWriteArrayList<MouseListener>();

    public MouseEventControl() {
    }

    public MouseEventControl(MouseListener ... listeners) {
        this.listeners.addAll(Arrays.asList(listeners));
    }

    public static void addListenersToSpatial(Spatial s, MouseListener ... listeners) {
        if (s == null) {
            return;
        }
        MouseEventControl mec = (MouseEventControl)s.getControl(MouseEventControl.class);
        if (mec == null) {
            s.addControl((Control)new MouseEventControl(listeners));
        } else {
            mec.listeners.addAll(Arrays.asList(listeners));
        }
    }

    public static void removeListenersFromSpatial(Spatial s, MouseListener ... listeners) {
        if (s == null) {
            return;
        }
        MouseEventControl mec = (MouseEventControl)s.getControl(MouseEventControl.class);
        if (mec == null) {
            return;
        }
        mec.listeners.removeAll(Arrays.asList(listeners));
    }

    public <T extends MouseListener> T getMouseListener(Class<T> type) {
        for (MouseListener l : this.listeners) {
            if (l.getClass() != type) continue;
            return (T)((MouseListener)type.cast(l));
        }
        return null;
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void addMouseListener(MouseListener l) {
        this.listeners.add(l);
    }

    public void removeMouseListener(MouseListener l) {
        this.listeners.remove(l);
    }

    public void mouseButtonEvent(MouseButtonEvent event, Spatial target, Spatial capture) {
        for (MouseListener l : this.listeners) {
            l.mouseButtonEvent(event, target, capture);
        }
    }

    public void mouseEntered(MouseMotionEvent event, Spatial target, Spatial capture) {
        for (MouseListener l : this.listeners) {
            l.mouseEntered(event, target, capture);
        }
    }

    public void mouseExited(MouseMotionEvent event, Spatial target, Spatial capture) {
        for (MouseListener l : this.listeners) {
            l.mouseExited(event, target, capture);
        }
    }

    public void mouseMoved(MouseMotionEvent event, Spatial target, Spatial capture) {
        for (MouseListener l : this.listeners) {
            l.mouseMoved(event, target, capture);
        }
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    protected void controlUpdate(float tpf) {
    }
}

