/*
 * Decompiled with CFR 0.152.
 */
package mythruna.assembly;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subassembly
implements Iterable<Subassembly> {
    static Logger log = LoggerFactory.getLogger(Subassembly.class);
    private String name;
    private ShapeName shapeName;
    private final Vec3d location;
    private final Quatd orientation;
    private double scale;
    private double mass;
    private List<Subassembly> children;

    public Subassembly() {
        this(null, null, new Vec3d(), new Quatd());
    }

    public Subassembly(String shapeName) {
        this(null, ShapeName.parse(shapeName), new Vec3d(), new Quatd());
    }

    public Subassembly(String name, ShapeName shapeName) {
        this(name, shapeName, new Vec3d(), new Quatd());
    }

    public Subassembly(ShapeName shapeName) {
        this(null, shapeName, new Vec3d(), new Quatd());
    }

    public Subassembly(String name, ShapeName shapeName, Vec3d location, Quatd orientation) {
        this.name = name;
        this.shapeName = shapeName;
        this.location = location;
        this.orientation = orientation;
        this.scale = 1.0;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setShapeName(ShapeName shapeName) {
        this.shapeName = shapeName;
    }

    public ShapeName getShapeName() {
        return this.shapeName;
    }

    public Set<Subassembly> findAllShapeAssemblies() {
        HashSet<Subassembly> results = new HashSet<Subassembly>();
        return this.findAllShapeAssemblies(results);
    }

    public Set<Subassembly> findAllShapeAssemblies(Set<Subassembly> results) {
        if (this.shapeName != null) {
            results.add(this);
        }
        if (this.children == null) {
            return results;
        }
        for (Subassembly child : this.children) {
            child.findAllShapeAssemblies(results);
        }
        return results;
    }

    public void setLocation(double x, double y, double z) {
        this.location.set(x, y, z);
    }

    public void setLocation(Vec3d location) {
        this.location.set(location);
    }

    public Vec3d getLocation() {
        return this.location;
    }

    public void setOrientation(Quatd orientation) {
        this.orientation.set(orientation);
    }

    public Quatd getOrientation() {
        return this.orientation;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getScale() {
        return this.scale;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public double getMass() {
        return this.mass;
    }

    public double getTotalMass() {
        double total = this.mass;
        if (this.children != null) {
            for (Subassembly child : this.children) {
                total += child.getTotalMass();
            }
        }
        return total;
    }

    public <T extends Subassembly> T addChild(T child) {
        if (this.children == null) {
            this.children = new ArrayList<Subassembly>();
        }
        this.children.add(child);
        return child;
    }

    public void removeChild(Subassembly child) {
        if (this.children == null) {
            return;
        }
        this.children.remove(child);
    }

    @Override
    public Iterator<Subassembly> iterator() {
        if (this.children == null) {
            List dumb = Collections.emptyList();
            return dumb.iterator();
        }
        return this.children.iterator();
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Subassembly other = (Subassembly)o;
        if (!Objects.equals(other.name, this.name)) {
            return false;
        }
        if (!Objects.equals(other.shapeName, this.shapeName)) {
            return false;
        }
        if (!Objects.equals(other.location, this.location)) {
            return false;
        }
        if (!Objects.equals(other.orientation, this.orientation)) {
            return false;
        }
        if (!Objects.equals(other.children, this.children)) {
            return false;
        }
        if (other.mass != this.mass) {
            return false;
        }
        return other.scale == this.scale;
    }

    public boolean isSimilar(Object o, double locEpsilon, double rotEpsilon) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Subassembly other = (Subassembly)o;
        if (!Objects.equals(other.name, this.name)) {
            return false;
        }
        if (!Objects.equals(other.shapeName, this.shapeName)) {
            return false;
        }
        if (!other.location.isSimilar(this.location, locEpsilon)) {
            return false;
        }
        if (!other.orientation.isSimilar(this.orientation, rotEpsilon)) {
            return false;
        }
        if (other.mass != this.mass) {
            return false;
        }
        if (other.scale != this.scale) {
            return false;
        }
        if (this.children != other.children && this.children != null) {
            int size = this.children.size();
            if (size != other.children.size()) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                Subassembly child2;
                Subassembly child1 = this.children.get(i);
                if (child1.isSimilar(child2 = other.children.get(i), locEpsilon, rotEpsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.shapeName, this.location, this.orientation, this.scale, this.mass, this.children);
    }

    protected MoreObjects.ToStringHelper appendToString(MoreObjects.ToStringHelper helper) {
        return helper.omitNullValues().add("name", (Object)this.name).add("shapeName", (Object)this.shapeName).add("location", (Object)this.location).add("orientation", (Object)this.orientation).add("mass", this.mass);
    }

    public String toString() {
        return this.appendToString(MoreObjects.toStringHelper((String)this.getClass().getSimpleName())).toString();
    }
}

