/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.WorldGrids;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightData
implements CellData {
    static Logger log = LoggerFactory.getLogger(LightData.class);
    private static final int SIZE = 32;
    private static final int CELL_COUNT = 32768;
    private static final boolean SLOW_CHECKS = false;
    private LeafId leafId;
    private CellArray cells;
    private int sunCellCount;
    private int emptyCellCount;

    public LightData(LeafId leafId) {
        this(leafId, null, 0, 32768);
    }

    public LightData(LeafId leafId, CellArray cells, int emptyCellCount, int sunCellCount) {
        this.leafId = leafId;
        this.cells = cells;
        this.emptyCellCount = emptyCellCount;
        this.sunCellCount = sunCellCount;
        if (sunCellCount < 0 || emptyCellCount < 0) {
            this.fixCounts();
        }
        assert (this.checkCounts());
    }

    public void clear(int value) {
        if (value == -65536) {
            this.emptyCellCount = 32768;
            this.sunCellCount = 0;
        } else if (value == LightUtils.DIRECT_SUN) {
            this.emptyCellCount = 0;
            this.sunCellCount = 32768;
        } else {
            this.cells = new CellArray(32);
            this.sunCellCount = 0;
            this.emptyCellCount = 0;
        }
        if (this.cells != null) {
            this.cells.clear(value);
        }
    }

    public final boolean checkCounts() {
        if (this.cells == null) {
            if (!this.isSolidDark() && !this.isFullSun()) {
                log.error("No cells but inconsistent counts, sun:" + this.sunCellCount + ", empty:" + this.emptyCellCount);
                return false;
            }
            return true;
        }
        int e = 0;
        int s = 0;
        for (int val : this.cells.getArray()) {
            if (val == -65536) {
                ++e;
            }
            if (val != LightUtils.DIRECT_SUN) continue;
            ++s;
        }
        if (e != this.emptyCellCount || s != this.sunCellCount) {
            log.error("Cell count check failed, counted empty:" + e + " sun:" + s + "  But have fields empty:" + this.emptyCellCount + " sun:" + this.sunCellCount);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean fixCounts() {
        try {
            if (this.cells == null) {
                if (this.isSolidDark() || this.isFullSun()) {
                    boolean bl = false;
                    return bl;
                }
                if (this.sunCellCount < this.emptyCellCount) {
                    this.emptyCellCount = 32768;
                } else {
                    this.sunCellCount = 32768;
                }
                boolean bl = true;
                return bl;
            }
            int e = 0;
            int s = 0;
            for (int val : this.cells.getArray()) {
                if (val == -65536) {
                    ++e;
                }
                if (val != LightUtils.DIRECT_SUN) continue;
                ++s;
            }
            if (e != this.emptyCellCount || s != this.sunCellCount) {
                this.emptyCellCount = e;
                this.sunCellCount = s;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            assert (this.checkCounts());
        }
    }

    public LeafId getLeafId() {
        return this.leafId;
    }

    public final int getSunCellCount() {
        return this.sunCellCount;
    }

    public final int getEmptyCellCount() {
        return this.emptyCellCount;
    }

    public final boolean isFullSun() {
        return this.sunCellCount == 32768;
    }

    public final boolean isSolidDark() {
        return this.emptyCellCount == 32768;
    }

    public final boolean containsCell(Vec3i world) {
        return this.containsCell(world.x, world.y, world.z);
    }

    public final boolean containsCell(int x, int y, int z) {
        long id = WorldGrids.LEAF_GRID.worldToId((double)x, (double)y, (double)z);
        return id == this.leafId.getId();
    }

    private boolean isValid(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return false;
        }
        return x < 32 && y < 32 && z < 32;
    }

    public int getCell(int x, int y, int z) {
        assert (this.isValid(x, y, z)) : "[" + x + ", " + y + ", " + z + "]";
        if (this.cells == null) {
            return this.isFullSun() ? LightUtils.DIRECT_SUN : -65536;
        }
        return this.cells.getCell(x, y, z);
    }

    public int getCell(int x, int y, int z, int defaultValue) {
        assert (this.isValid(x, y, z)) : "[" + x + ", " + y + ", " + z + "]";
        if (this.cells == null) {
            return this.isFullSun() ? LightUtils.DIRECT_SUN : -65536;
        }
        return this.cells.getCell(x, y, z, defaultValue);
    }

    public int getCell(int x, int y, int z, Direction dir, int defaultValue) {
        assert (this.isValid(x, y, z)) : "[" + x + ", " + y + ", " + z + "]";
        if (this.cells == null) {
            return this.isFullSun() ? LightUtils.DIRECT_SUN : -65536;
        }
        return this.cells.getCell(x, y, z, dir, defaultValue);
    }

    public void setCell(int x, int y, int z, int value) {
        assert (this.isValid(x, y, z)) : "[" + x + ", " + y + ", " + z + "]";
        if (this.cells == null) {
            if (value == LightUtils.DIRECT_SUN && this.isFullSun()) {
                return;
            }
            if (value == -65536 && this.isSolidDark()) {
                return;
            }
            this.cells = new CellArray(32);
            if (this.isFullSun()) {
                this.cells.clear(LightUtils.DIRECT_SUN);
            } else if (this.isSolidDark()) {
                this.cells.clear(-65536);
            } else {
                throw new RuntimeException("Invalid state during cell array initialization");
            }
            this.cells.setCell(x, y, z, value);
            if (this.isFullSun()) {
                --this.sunCellCount;
            }
            if (this.isSolidDark()) {
                --this.emptyCellCount;
            }
            if (value == -65536) {
                ++this.emptyCellCount;
            }
            if (value == LightUtils.DIRECT_SUN) {
                ++this.sunCellCount;
            }
            return;
        }
        int oldVal = this.cells.getCell(x, y, z);
        if (oldVal == value) {
            return;
        }
        this.cells.setCell(x, y, z, value);
        int oSun = this.sunCellCount--;
        int oEmpty = this.emptyCellCount;
        if (oldVal == LightUtils.DIRECT_SUN) {
            // empty if block
        }
        if (oldVal == -65536) {
            --this.emptyCellCount;
        }
        if (value == LightUtils.DIRECT_SUN) {
            ++this.sunCellCount;
        }
        if (value == -65536) {
            ++this.emptyCellCount;
        }
    }

    public CellArray getRawCells() {
        return this.cells;
    }

    public int[] getArray() {
        return this.cells == null ? null : this.cells.getArray();
    }

    public void compact() {
        if (this.isSolidDark() || this.isFullSun()) {
            this.cells = null;
        }
    }

    public void setData(LightData data) {
        if (this.cells == null || data.cells == null) {
            this.cells = data.cells;
        } else {
            this.cells.set(data.cells);
        }
        this.sunCellCount = data.sunCellCount;
        this.emptyCellCount = data.emptyCellCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("id", (Object)this.leafId).add("sunCellCount", this.sunCellCount).add("emptyCellCount", this.emptyCellCount).add("cells", (Object)this.cells).toString();
    }
}

